/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.ordinal;

import org.immutables.check.Checkers;
import org.immutables.ordinal.ImmutableOrdinalSet;
import org.immutables.ordinal.ImmutableSillyOrdinal;
import org.immutables.ordinal.ImmutableSillyOrdinalHolder;
import org.immutables.ordinal.SillyOrdinal;
import org.junit.Test;

public class OrdinalValueTest {
    @Test
    public void ordinalValue() {
        ImmutableSillyOrdinal a = ImmutableSillyOrdinal.of("a");
        ImmutableSillyOrdinal b = ImmutableSillyOrdinal.of("b");
        ImmutableSillyOrdinal c = ImmutableSillyOrdinal.of("c");
        Checkers.checkAll((Object[])new Integer[]{a.ordinal(), b.ordinal(), c.ordinal()}).isOf((Object[])new Integer[]{0, 1, 2});
        Checkers.check((Object)ImmutableSillyOrdinal.of("a")).same((Object)a);
        Checkers.check((Object)ImmutableSillyOrdinal.of("b")).same((Object)b);
        Checkers.check((Object)a.domain().get(1)).same((Object)b);
        Checkers.check((Object)a.domain().get(0)).same((Object)a);
        Checkers.check((Object)a.domain().length()).is((Object)3);
        Checkers.check(a.domain()).isOf((Object[])new SillyOrdinal[]{a, b, c});
    }

    @Test
    public void ordinalDomain() {
        ImmutableSillyOrdinal.Domain domain = new ImmutableSillyOrdinal.Domain();
        ImmutableSillyOrdinal a = ImmutableSillyOrdinal.of("a");
        ImmutableSillyOrdinal a1 = ImmutableSillyOrdinal.builder().domain(domain).name("a").build();
        ImmutableSillyOrdinal a2 = ImmutableSillyOrdinal.builder().domain(domain).name("a").build();
        Checkers.check(a.domain()).not((Object)domain);
        Checkers.check(a.domain()).same((Object)ImmutableSillyOrdinal.Domain.get());
        Checkers.check(a1.domain()).same((Object)domain);
        Checkers.check((Object)a).not((Object)a1);
        Checkers.check((Object)a1).same((Object)a2);
        Checkers.check((Object)domain.length()).is((Object)1);
    }

    @Test
    public void ordinalValueSet() {
        Checkers.check(ImmutableSillyOrdinalHolder.builder().addSet((SillyOrdinal)ImmutableSillyOrdinal.of("a")).build().set()).isA(ImmutableOrdinalSet.class);
    }
}

