/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableInDefaultPackage
implements InDefaultPackage {
    private final int attr;

    private ImmutableInDefaultPackage(int attr) {
        this.attr = attr;
    }

    @Override
    public int attr() {
        return this.attr;
    }

    public final ImmutableInDefaultPackage withAttr(int value) {
        if (this.attr == value) {
            return this;
        }
        return new ImmutableInDefaultPackage(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInDefaultPackage && this.equalTo((ImmutableInDefaultPackage)another);
    }

    private boolean equalTo(ImmutableInDefaultPackage another) {
        return this.attr == another.attr;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.attr;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InDefaultPackage").add("attr", this.attr).toString();
    }

    public static ImmutableInDefaultPackage copyOf(InDefaultPackage instance) {
        if (instance instanceof ImmutableInDefaultPackage) {
            return (ImmutableInDefaultPackage)instance;
        }
        return ImmutableInDefaultPackage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_ATTR = 1L;
        private long initBits = 1L;
        private int attr;

        private Builder() {
        }

        public final Builder from(InDefaultPackage instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.attr(instance.attr());
            return this;
        }

        public final Builder attr(int attr) {
            this.attr = attr;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInDefaultPackage build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInDefaultPackage(this.attr);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attr");
            }
            return "Cannot build InDefaultPackage, some of required attributes are not set " + attributes;
        }
    }
}

