/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ExtendingInnerBuilderValue;

@ParametersAreNonnullByDefault
@NotThreadSafe
public class ExtendingInnerBuilderValue_Builder {
    private static final long INIT_BIT_ATTRIBUTE = 1L;
    private long initBits = 1L;
    private int attribute;
    private ImmutableList.Builder<String> listBuilder = ImmutableList.builder();

    public ExtendingInnerBuilderValue_Builder() {
        if (!(this instanceof ExtendingInnerBuilderValue.Builder)) {
            throw new UnsupportedOperationException("Use: new ExtendingInnerBuilderValue.Builder()");
        }
    }

    public final ExtendingInnerBuilderValue.Builder from(ExtendingInnerBuilderValue instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        this.attribute(instance.attribute());
        this.addAllList(instance.list());
        return (ExtendingInnerBuilderValue.Builder)this;
    }

    public final ExtendingInnerBuilderValue.Builder attribute(int attribute) {
        this.attribute = attribute;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (ExtendingInnerBuilderValue.Builder)this;
    }

    public final ExtendingInnerBuilderValue.Builder addList(String element) {
        this.listBuilder.add((Object)element);
        return (ExtendingInnerBuilderValue.Builder)this;
    }

    public final ExtendingInnerBuilderValue.Builder addList(String ... elements) {
        this.listBuilder.add((Object[])elements);
        return (ExtendingInnerBuilderValue.Builder)this;
    }

    public final ExtendingInnerBuilderValue.Builder list(Iterable<String> elements) {
        this.listBuilder = ImmutableList.builder();
        return this.addAllList(elements);
    }

    public final ExtendingInnerBuilderValue.Builder addAllList(Iterable<String> elements) {
        this.listBuilder.addAll(elements);
        return (ExtendingInnerBuilderValue.Builder)this;
    }

    public ExtendingInnerBuilderValue build() throws IllegalStateException {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableExtendingInnerBuilderValue(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("attribute");
        }
        return "Cannot build ExtendingInnerBuilderValue, some of required attributes are not set " + attributes;
    }

    @Immutable
    private static final class ImmutableExtendingInnerBuilderValue
    extends ExtendingInnerBuilderValue {
        private final int attribute;
        private final ImmutableList<String> list;

        private ImmutableExtendingInnerBuilderValue(ExtendingInnerBuilderValue_Builder builder) {
            this.attribute = builder.attribute;
            this.list = builder.listBuilder.build();
        }

        @Override
        int attribute() {
            return this.attribute;
        }

        ImmutableList<String> list() {
            return this.list;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableExtendingInnerBuilderValue && this.equalTo((ImmutableExtendingInnerBuilderValue)another);
        }

        private boolean equalTo(ImmutableExtendingInnerBuilderValue another) {
            return this.attribute == another.attribute && this.list.equals(another.list);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.attribute;
            h = h * 17 + this.list.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ExtendingInnerBuilderValue").add("attribute", this.attribute).add("list", this.list).toString();
        }
    }
}

