/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.HeaderCopy;
import org.immutables.fixture.ImmutableHeaderCopy;

@ParametersAreNonnullByDefault
public final class GsonAdaptersHeaderCopy
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (HeaderCopyTypeAdapter.adapts(type)) {
            return new HeaderCopyTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersHeaderCopy(HeaderCopy)";
    }

    private static class HeaderCopyTypeAdapter
    extends TypeAdapter<HeaderCopy> {
        private static final TypeToken<HeaderCopy> HEADER_COPY_ABSTRACT = TypeToken.get(HeaderCopy.class);
        private static final TypeToken<ImmutableHeaderCopy> HEADER_COPY_IMMUTABLE = TypeToken.get(ImmutableHeaderCopy.class);

        HeaderCopyTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return HEADER_COPY_ABSTRACT.equals(type) || HEADER_COPY_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, HeaderCopy value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeHeaderCopy(out, value);
            }
        }

        public HeaderCopy read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readHeaderCopy(in);
        }

        private void writeHeaderCopy(JsonWriter out, HeaderCopy instance) throws IOException {
            out.beginObject();
            out.endObject();
        }

        private HeaderCopy readHeaderCopy(JsonReader in) throws IOException {
            ImmutableHeaderCopy.Builder builder = ImmutableHeaderCopy.builder();
            in.skipValue();
            return builder.build();
        }
    }
}

