/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableJsonIgnore;
import org.immutables.fixture.JsonIgnore;

@ParametersAreNonnullByDefault
public final class GsonAdaptersJsonIgnore
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (JsonIgnoreTypeAdapter.adapts(type)) {
            return new JsonIgnoreTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersJsonIgnore(JsonIgnore)";
    }

    private static class JsonIgnoreTypeAdapter
    extends TypeAdapter<JsonIgnore> {
        private static final TypeToken<JsonIgnore> JSON_IGNORE_ABSTRACT = TypeToken.get(JsonIgnore.class);
        private static final TypeToken<ImmutableJsonIgnore> JSON_IGNORE_IMMUTABLE = TypeToken.get(ImmutableJsonIgnore.class);

        JsonIgnoreTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return JSON_IGNORE_ABSTRACT.equals(type) || JSON_IGNORE_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, JsonIgnore value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeJsonIgnore(out, value);
            }
        }

        public JsonIgnore read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readJsonIgnore(in);
        }

        private void writeJsonIgnore(JsonWriter out, JsonIgnore instance) throws IOException {
            out.beginObject();
            out.name("value");
            out.value((long)instance.value());
            out.endObject();
        }

        private JsonIgnore readJsonIgnore(JsonReader in) throws IOException {
            ImmutableJsonIgnore.Builder builder = ImmutableJsonIgnore.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableJsonIgnore.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'v': {
                    if (!"value".equals(attributeName)) break;
                    this.readInValue(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInValue(JsonReader in, ImmutableJsonIgnore.Builder builder) throws IOException {
            builder.value(in.nextInt());
        }
    }
}

