/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyEntitySecond;
import org.immutables.fixture.SillyEntitySecond;
import org.immutables.mongo.types.Id;

@ParametersAreNonnullByDefault
public final class GsonAdaptersSillyEntitySecond
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyEntitySecondTypeAdapter.adapts(type)) {
            return new SillyEntitySecondTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyEntitySecond(SillyEntitySecond)";
    }

    private static class SillyEntitySecondTypeAdapter
    extends TypeAdapter<SillyEntitySecond> {
        private static final TypeToken<SillyEntitySecond> SILLY_ENTITY_SECOND_ABSTRACT = TypeToken.get(SillyEntitySecond.class);
        private static final TypeToken<ImmutableSillyEntitySecond> SILLY_ENTITY_SECOND_IMMUTABLE = TypeToken.get(ImmutableSillyEntitySecond.class);
        private static final TypeToken<Id> ID_TYPE_TOKEN = TypeToken.get(Id.class);
        private final TypeAdapter<Id> idTypeAdapter;

        SillyEntitySecondTypeAdapter(Gson gson) {
            this.idTypeAdapter = gson.getAdapter(ID_TYPE_TOKEN);
        }

        static boolean adapts(TypeToken<?> type) {
            return SILLY_ENTITY_SECOND_ABSTRACT.equals(type) || SILLY_ENTITY_SECOND_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, SillyEntitySecond value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyEntitySecond(out, value);
            }
        }

        public SillyEntitySecond read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readSillyEntitySecond(in);
        }

        private void writeSillyEntitySecond(JsonWriter out, SillyEntitySecond instance) throws IOException {
            out.beginObject();
            out.name("_id");
            this.idTypeAdapter.write(out, (Object)instance.id());
            out.endObject();
        }

        private SillyEntitySecond readSillyEntitySecond(JsonReader in) throws IOException {
            ImmutableSillyEntitySecond.Builder builder = ImmutableSillyEntitySecond.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSillyEntitySecond.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if (!"_id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableSillyEntitySecond.Builder builder) throws IOException {
            Id value = (Id)this.idTypeAdapter.read(in);
            builder.id(value);
        }
    }
}

