/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyIntWrap;
import org.immutables.fixture.SillyIntWrap;

@ParametersAreNonnullByDefault
public final class GsonAdaptersSillyIntWrap
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyIntWrapTypeAdapter.adapts(type)) {
            return new SillyIntWrapTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyIntWrap(SillyIntWrap)";
    }

    private static class SillyIntWrapTypeAdapter
    extends TypeAdapter<SillyIntWrap> {
        private static final TypeToken<SillyIntWrap> SILLY_INT_WRAP_ABSTRACT = TypeToken.get(SillyIntWrap.class);
        private static final TypeToken<ImmutableSillyIntWrap> SILLY_INT_WRAP_IMMUTABLE = TypeToken.get(ImmutableSillyIntWrap.class);

        SillyIntWrapTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return SILLY_INT_WRAP_ABSTRACT.equals(type) || SILLY_INT_WRAP_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, SillyIntWrap value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyIntWrap(out, value);
            }
        }

        public SillyIntWrap read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readSillyIntWrap(in);
        }

        private void writeSillyIntWrap(JsonWriter out, SillyIntWrap instance) throws IOException {
            out.value((long)instance.value());
        }

        private SillyIntWrap readSillyIntWrap(JsonReader in) throws IOException {
            return ImmutableSillyIntWrap.of(this.readParameterValue(in));
        }

        private int readParameterValue(JsonReader in) throws IOException {
            return in.nextInt();
        }
    }
}

