/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyStructureWithId;
import org.immutables.fixture.SillyStructureWithId;
import org.immutables.fixture.SillyTuplie;
import org.immutables.fixture.subpack.SillySubstructure;

@ParametersAreNonnullByDefault
public final class GsonAdaptersSillyStructureWithId
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyStructureWithIdTypeAdapter.adapts(type)) {
            return new SillyStructureWithIdTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyStructureWithId(SillyStructureWithId)";
    }

    private static class SillyStructureWithIdTypeAdapter
    extends TypeAdapter<SillyStructureWithId> {
        private static final TypeToken<SillyStructureWithId> SILLY_STRUCTURE_WITH_ID_ABSTRACT = TypeToken.get(SillyStructureWithId.class);
        private static final TypeToken<ImmutableSillyStructureWithId> SILLY_STRUCTURE_WITH_ID_IMMUTABLE = TypeToken.get(ImmutableSillyStructureWithId.class);
        private static final TypeToken<SillySubstructure> SUBS6_TYPE_TOKEN = TypeToken.get(SillySubstructure.class);
        private static final TypeToken<SillySubstructure> NEST7_TYPE_TOKEN = TypeToken.get(SillySubstructure.class);
        private static final TypeToken<SillyTuplie> TUP3_TYPE_TOKEN = TypeToken.get(SillyTuplie.class);
        private final TypeAdapter<SillySubstructure> subs6TypeAdapter;
        private final TypeAdapter<SillySubstructure> nest7TypeAdapter;
        private final TypeAdapter<SillyTuplie> tup3TypeAdapter;

        SillyStructureWithIdTypeAdapter(Gson gson) {
            this.subs6TypeAdapter = gson.getAdapter(SUBS6_TYPE_TOKEN);
            this.nest7TypeAdapter = gson.getAdapter(NEST7_TYPE_TOKEN);
            this.tup3TypeAdapter = gson.getAdapter(TUP3_TYPE_TOKEN);
        }

        static boolean adapts(TypeToken<?> type) {
            return SILLY_STRUCTURE_WITH_ID_ABSTRACT.equals(type) || SILLY_STRUCTURE_WITH_ID_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, SillyStructureWithId value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyStructureWithId(out, value);
            }
        }

        public SillyStructureWithId read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readSillyStructureWithId(in);
        }

        private void writeSillyStructureWithId(JsonWriter out, SillyStructureWithId instance) throws IOException {
            out.beginObject();
            out.name("_id");
            out.value(instance.id());
            out.name("attr1");
            out.value(instance.attr1());
            out.name("flag2");
            out.value(instance.flag2());
            Optional<Integer> opt3Optional = instance.opt3();
            if (opt3Optional.isPresent()) {
                out.name("opt3");
                int opt3Value = (Integer)opt3Optional.get();
                out.value((long)opt3Value);
            } else if (out.getSerializeNulls()) {
                out.name("opt3");
                out.nullValue();
            }
            com.atlassian.fugue.Option<Integer> opt4Optional = instance.opt4();
            if (opt4Optional.isDefined()) {
                out.name("opt4");
                int opt4Value = (Integer)opt4Optional.get();
                out.value((long)opt4Value);
            } else if (out.getSerializeNulls()) {
                out.name("opt4");
                out.nullValue();
            }
            Option<Integer> opt5Optional = instance.opt5();
            if (opt5Optional.isDefined()) {
                out.name("opt5");
                int opt5Value = (Integer)opt5Optional.get();
                out.value((long)opt5Value);
            } else if (out.getSerializeNulls()) {
                out.name("opt5");
                out.nullValue();
            }
            out.name("very4");
            out.value(instance.very4());
            out.name("wet5");
            out.value(instance.wet5());
            List<SillySubstructure> subs6Elements = instance.subs6();
            out.name("subs6");
            out.beginArray();
            for (SillySubstructure e : subs6Elements) {
                this.subs6TypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("nest7");
            this.nest7TypeAdapter.write(out, (Object)instance.nest7());
            Optional<SillyTuplie> tup3Optional = instance.tup3();
            if (tup3Optional.isPresent()) {
                out.name("tup3");
                SillyTuplie tup3Value = (SillyTuplie)tup3Optional.get();
                this.tup3TypeAdapter.write(out, (Object)tup3Value);
            } else if (out.getSerializeNulls()) {
                out.name("tup3");
                out.nullValue();
            }
            out.name("int9");
            out.value((long)instance.int9());
            out.endObject();
        }

        private SillyStructureWithId readSillyStructureWithId(JsonReader in) throws IOException {
            ImmutableSillyStructureWithId.Builder builder = ImmutableSillyStructureWithId.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if (!"_id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'a': {
                    if (!"attr1".equals(attributeName)) break;
                    this.readInAttr1(in, builder);
                    return;
                }
                case 'f': {
                    if (!"flag2".equals(attributeName)) break;
                    this.readInFlag2(in, builder);
                    return;
                }
                case 'o': {
                    if ("opt3".equals(attributeName)) {
                        this.readInOpt3(in, builder);
                        return;
                    }
                    if ("opt4".equals(attributeName)) {
                        this.readInOpt4(in, builder);
                        return;
                    }
                    if (!"opt5".equals(attributeName)) break;
                    this.readInOpt5(in, builder);
                    return;
                }
                case 'v': {
                    if (!"very4".equals(attributeName)) break;
                    this.readInVery4(in, builder);
                    return;
                }
                case 'w': {
                    if (!"wet5".equals(attributeName)) break;
                    this.readInWet5(in, builder);
                    return;
                }
                case 's': {
                    if (!"subs6".equals(attributeName)) break;
                    this.readInSubs6(in, builder);
                    return;
                }
                case 'n': {
                    if (!"nest7".equals(attributeName)) break;
                    this.readInNest7(in, builder);
                    return;
                }
                case 't': {
                    if (!"tup3".equals(attributeName)) break;
                    this.readInTup3(in, builder);
                    return;
                }
                case 'i': {
                    if (!"int9".equals(attributeName)) break;
                    this.readInInt9(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            builder.id(in.nextString());
        }

        private void readInAttr1(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            builder.attr1(in.nextString());
        }

        private void readInFlag2(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            builder.flag2(in.nextBoolean());
        }

        private void readInOpt3(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.opt3(in.nextInt());
            }
        }

        private void readInOpt4(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.opt4(in.nextInt());
            }
        }

        private void readInOpt5(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.opt5(in.nextInt());
            }
        }

        private void readInVery4(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            builder.very4(in.nextLong());
        }

        private void readInWet5(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            builder.wet5(in.nextDouble());
        }

        private void readInSubs6(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    SillySubstructure value = (SillySubstructure)this.subs6TypeAdapter.read(in);
                    builder.addSubs6(value);
                }
                in.endArray();
            } else if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                SillySubstructure value = (SillySubstructure)this.subs6TypeAdapter.read(in);
                builder.addSubs6(value);
            }
        }

        private void readInNest7(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            SillySubstructure value = (SillySubstructure)this.nest7TypeAdapter.read(in);
            builder.nest7(value);
        }

        private void readInTup3(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                SillyTuplie value = (SillyTuplie)this.tup3TypeAdapter.read(in);
                builder.tup3(value);
            }
        }

        private void readInInt9(JsonReader in, ImmutableSillyStructureWithId.Builder builder) throws IOException {
            builder.int9(in.nextInt());
        }
    }
}

