/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyTuplie;
import org.immutables.fixture.SillyTuplie;

@ParametersAreNonnullByDefault
public final class GsonAdaptersSillyTuplie
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyTuplieTypeAdapter.adapts(type)) {
            return new SillyTuplieTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyTuplie(SillyTuplie)";
    }

    private static class SillyTuplieTypeAdapter
    extends TypeAdapter<SillyTuplie> {
        private static final TypeToken<SillyTuplie> SILLY_TUPLIE_ABSTRACT = TypeToken.get(SillyTuplie.class);
        private static final TypeToken<ImmutableSillyTuplie> SILLY_TUPLIE_IMMUTABLE = TypeToken.get(ImmutableSillyTuplie.class);

        SillyTuplieTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return SILLY_TUPLIE_ABSTRACT.equals(type) || SILLY_TUPLIE_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, SillyTuplie value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyTuplie(out, value);
            }
        }

        public SillyTuplie read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readSillyTuplie(in);
        }

        private void writeSillyTuplie(JsonWriter out, SillyTuplie instance) throws IOException {
            out.beginArray();
            out.value((double)instance.float1());
            Optional<Byte> opt2Optional = instance.opt2();
            if (opt2Optional.isPresent()) {
                byte opt2Value = (Byte)opt2Optional.get();
                out.value((long)opt2Value);
            } else {
                out.nullValue();
            }
            out.beginArray();
            for (boolean e : instance.set3()) {
                out.value(e);
            }
            out.endArray();
            out.endArray();
        }

        private SillyTuplie readSillyTuplie(JsonReader in) throws IOException {
            in.beginArray();
            ImmutableSillyTuplie instance = ImmutableSillyTuplie.of(this.readParameterFloat1(in), this.readParameterOpt2(in), this.readParameterSet3(in));
            in.endArray();
            return instance;
        }

        private float readParameterFloat1(JsonReader in) throws IOException {
            return (float)in.nextDouble();
        }

        private Optional<Byte> readParameterOpt2(JsonReader in) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
                return Optional.absent();
            }
            return Optional.of((Object)((byte)in.nextInt()));
        }

        private Iterable<Boolean> readParameterSet3(JsonReader in) throws IOException {
            ImmutableSet.Builder elements = ImmutableSet.builder();
            JsonToken t = in.peek();
            if (t == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    elements.add((Object)in.nextBoolean());
                }
                in.endArray();
            } else if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                elements.add((Object)in.nextBoolean());
            }
            return elements.build();
        }
    }
}

