/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.AlternativeConstructor;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableAlternativeConstructor
extends AlternativeConstructor {
    private final ImmutableList<String> foo;

    private ImmutableAlternativeConstructor(Iterable<String> foo) {
        this.foo = ImmutableList.copyOf(foo);
    }

    private ImmutableAlternativeConstructor(ImmutableAlternativeConstructor original, ImmutableList<String> foo) {
        this.foo = foo;
    }

    public ImmutableList<String> foo() {
        return this.foo;
    }

    public final ImmutableAlternativeConstructor withFoo(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAlternativeConstructor(this, (ImmutableList<String>)newValue);
    }

    public final ImmutableAlternativeConstructor withFoo(Iterable<String> elements) {
        if (this.foo == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAlternativeConstructor(this, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAlternativeConstructor && this.equalTo((ImmutableAlternativeConstructor)another);
    }

    private boolean equalTo(ImmutableAlternativeConstructor another) {
        return this.foo.equals(another.foo);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.foo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AlternativeConstructor").add("foo", this.foo).toString();
    }

    public static ImmutableAlternativeConstructor of(List<String> foo) {
        return ImmutableAlternativeConstructor.of(foo);
    }

    public static ImmutableAlternativeConstructor of(Iterable<String> foo) {
        return new ImmutableAlternativeConstructor(foo);
    }

    public static ImmutableAlternativeConstructor copyOf(AlternativeConstructor instance) {
        if (instance instanceof ImmutableAlternativeConstructor) {
            return (ImmutableAlternativeConstructor)instance;
        }
        return ImmutableAlternativeConstructor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> fooBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(AlternativeConstructor instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllFoo(instance.foo());
            return this;
        }

        public final Builder addFoo(String element) {
            this.fooBuilder.add((Object)element);
            return this;
        }

        public final Builder addFoo(String ... elements) {
            this.fooBuilder.add((Object[])elements);
            return this;
        }

        public final Builder foo(Iterable<String> elements) {
            this.fooBuilder = ImmutableList.builder();
            return this.addAllFoo(elements);
        }

        public final Builder addAllFoo(Iterable<String> elements) {
            this.fooBuilder.addAll(elements);
            return this;
        }

        public ImmutableAlternativeConstructor build() throws IllegalStateException {
            return new ImmutableAlternativeConstructor(null, this.fooBuilder.build());
        }
    }
}

