/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.DefaultAsDefault;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDefaultAsDefault
implements DefaultAsDefault {
    private final int a;
    private final int b;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();

    private ImmutableDefaultAsDefault(Builder builder) {
        if (builder.aIsSet()) {
            this.initShim.a(builder.a);
        }
        if (builder.bIsSet()) {
            this.initShim.b(builder.b);
        }
        this.a = this.initShim.a();
        this.b = this.initShim.b();
        this.initShim = null;
    }

    private ImmutableDefaultAsDefault(int a, int b) {
        this.a = a;
        this.b = b;
        this.initShim.a(a);
        this.initShim.b(b);
        this.initShim = null;
    }

    private int aInitialize() {
        return DefaultAsDefault.super.a();
    }

    private int bInitialize() {
        return DefaultAsDefault.super.b();
    }

    @Override
    public int a() {
        return this.initShim != null ? this.initShim.a() : this.a;
    }

    @Override
    public int b() {
        return this.initShim != null ? this.initShim.b() : this.b;
    }

    public final ImmutableDefaultAsDefault withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableDefaultAsDefault(value, this.b);
    }

    public final ImmutableDefaultAsDefault withB(int value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableDefaultAsDefault(this.a, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultAsDefault && this.equalTo((ImmutableDefaultAsDefault)another);
    }

    private boolean equalTo(ImmutableDefaultAsDefault another) {
        return this.a == another.a && this.b == another.b;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a;
        h = h * 17 + this.b;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultAsDefault").add("a", this.a).add("b", this.b).toString();
    }

    public static ImmutableDefaultAsDefault copyOf(DefaultAsDefault instance) {
        if (instance instanceof ImmutableDefaultAsDefault) {
            return (ImmutableDefaultAsDefault)instance;
        }
        return ImmutableDefaultAsDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_A = 1L;
        private static final long OPT_BIT_B = 2L;
        private long optBits;
        private int a;
        private int b;

        private Builder() {
        }

        public final Builder from(DefaultAsDefault instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.a());
            this.b(instance.b());
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.optBits |= 1L;
            return this;
        }

        public final Builder b(int b) {
            this.b = b;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableDefaultAsDefault build() throws IllegalStateException {
            return new ImmutableDefaultAsDefault(this);
        }

        private boolean aIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean bIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private int a;
        private byte aStage;
        private int b;
        private byte bStage;

        private InitShim() {
        }

        int a() {
            if (this.aStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aStage == 0) {
                this.aStage = (byte)-1;
                this.a = ImmutableDefaultAsDefault.this.aInitialize();
                this.aStage = 1;
            }
            return this.a;
        }

        int a(int value) {
            this.a = value;
            this.aStage = 1;
            return value;
        }

        int b() {
            if (this.bStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bStage == 0) {
                this.bStage = (byte)-1;
                this.b = ImmutableDefaultAsDefault.this.bInitialize();
                this.bStage = 1;
            }
            return this.b;
        }

        int b(int value) {
            this.b = value;
            this.bStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.aStage == -1) {
                attributes.add("a");
            }
            if (this.bStage == -1) {
                attributes.add("b");
            }
            return "Cannot build DefaultAsDefault, attribute initializers form cycle" + attributes;
        }
    }
}

