/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.DefaultDerivedInit;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDefaultDerivedInit
extends DefaultDerivedInit {
    private final String index;
    private final String uuid;
    private final String title;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();

    private ImmutableDefaultDerivedInit(String uuid, String title) {
        this.uuid = (String)Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        this.title = (String)Preconditions.checkNotNull((Object)title, (Object)"title");
        this.initShim.uuid(uuid);
        this.index = this.initShim.index();
        this.initShim = null;
    }

    private ImmutableDefaultDerivedInit(Builder builder) {
        this.title = builder.title;
        if (builder.uuid != null) {
            this.initShim.uuid(builder.uuid);
        }
        this.uuid = this.initShim.uuid();
        this.index = this.initShim.index();
        this.initShim = null;
    }

    private ImmutableDefaultDerivedInit(ImmutableDefaultDerivedInit original, String uuid, String title) {
        this.uuid = uuid;
        this.title = title;
        this.initShim.uuid(uuid);
        this.index = this.initShim.index();
        this.initShim = null;
    }

    @Override
    public String index() {
        return this.initShim != null ? this.initShim.index() : this.index;
    }

    @Override
    public String uuid() {
        return this.initShim != null ? this.initShim.uuid() : this.uuid;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableDefaultDerivedInit withUuid(String value) {
        if (this.uuid.equals(value)) {
            return this;
        }
        return new ImmutableDefaultDerivedInit(this, (String)Preconditions.checkNotNull((Object)value, (Object)"uuid"), this.title);
    }

    public final ImmutableDefaultDerivedInit withTitle(String value) {
        if (this.title.equals(value)) {
            return this;
        }
        return new ImmutableDefaultDerivedInit(this, this.uuid, (String)Preconditions.checkNotNull((Object)value, (Object)"title"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultDerivedInit && this.equalTo((ImmutableDefaultDerivedInit)another);
    }

    private boolean equalTo(ImmutableDefaultDerivedInit another) {
        return this.index.equals(another.index) && this.uuid.equals(another.uuid) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.index.hashCode();
        h = h * 17 + this.uuid.hashCode();
        h = h * 17 + this.title.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultDerivedInit").add("index", (Object)this.index).add("uuid", (Object)this.uuid).add("title", (Object)this.title).toString();
    }

    public static ImmutableDefaultDerivedInit of(String uuid, String title) {
        return new ImmutableDefaultDerivedInit(uuid, title);
    }

    public static ImmutableDefaultDerivedInit copyOf(DefaultDerivedInit instance) {
        if (instance instanceof ImmutableDefaultDerivedInit) {
            return (ImmutableDefaultDerivedInit)instance;
        }
        return ImmutableDefaultDerivedInit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String uuid;
        @Nullable
        private String title;

        private Builder() {
        }

        public final Builder from(DefaultDerivedInit instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.uuid(instance.uuid());
            this.title(instance.title());
            return this;
        }

        public final Builder uuid(String uuid) {
            this.uuid = (String)Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
            return this;
        }

        public final Builder title(String title) {
            this.title = (String)Preconditions.checkNotNull((Object)title, (Object)"title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDefaultDerivedInit build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDefaultDerivedInit(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build DefaultDerivedInit, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private String index;
        private byte indexStage;
        private String uuid;
        private byte uuidStage;

        private InitShim() {
        }

        String index() {
            if (this.indexStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexStage == 0) {
                this.indexStage = (byte)-1;
                this.index = (String)Preconditions.checkNotNull((Object)ImmutableDefaultDerivedInit.super.index(), (Object)"index");
                this.indexStage = 1;
            }
            return this.index;
        }

        String uuid() {
            if (this.uuidStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uuidStage == 0) {
                this.uuidStage = (byte)-1;
                this.uuid = (String)Preconditions.checkNotNull((Object)ImmutableDefaultDerivedInit.super.uuid(), (Object)"uuid");
                this.uuidStage = 1;
            }
            return this.uuid;
        }

        String uuid(String value) {
            this.uuid = value;
            this.uuidStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.indexStage == -1) {
                attributes.add("index");
            }
            if (this.uuidStage == -1) {
                attributes.add("uuid");
            }
            return "Cannot build DefaultDerivedInit, attribute initializers form cycle" + attributes;
        }
    }
}

