/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.GetterEncloser;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableGetterEncloser
implements GetterEncloser {
    private final Optional<Integer> optional;

    private ImmutableGetterEncloser(Optional<Integer> optional) {
        this.optional = optional;
    }

    @Override
    public Optional<Integer> optional() {
        return this.optional;
    }

    public final ImmutableGetterEncloser withOptional(int value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableGetterEncloser((Optional<Integer>)newValue);
    }

    public final ImmutableGetterEncloser withOptional(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"optional");
        if (this.optional == value) {
            return this;
        }
        return new ImmutableGetterEncloser((Optional<Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetterEncloser && this.equalTo((ImmutableGetterEncloser)another);
    }

    private boolean equalTo(ImmutableGetterEncloser another) {
        return this.optional.equals(another.optional);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.optional.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GetterEncloser").add("optional", this.optional).toString();
    }

    public static ImmutableGetterEncloser copyOf(GetterEncloser instance) {
        if (instance instanceof ImmutableGetterEncloser) {
            return (ImmutableGetterEncloser)instance;
        }
        return ImmutableGetterEncloser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<Integer> optional = Optional.absent();

        private Builder() {
        }

        public final Builder from(GetterEncloser instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Integer> optionalOptional = instance.optional();
            if (optionalOptional.isPresent()) {
                this.optional(optionalOptional);
            }
            return this;
        }

        public final Builder optional(int optional) {
            this.optional = Optional.of((Object)optional);
            return this;
        }

        public final Builder optional(Optional<Integer> optional) {
            this.optional = (Optional)Preconditions.checkNotNull(optional, (Object)"optional");
            return this;
        }

        public ImmutableGetterEncloser build() throws IllegalStateException {
            return new ImmutableGetterEncloser(this.optional);
        }
    }
}

