/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import nonimmutables.GetterAnnotation;
import org.immutables.fixture.GetterEncloser;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableGetters
implements GetterEncloser.Getters {
    private final int ab;
    private final String cd;
    private final boolean ef;

    private ImmutableGetters(int ab, String cd, boolean ef) {
        this.ab = ab;
        this.cd = cd;
        this.ef = ef;
    }

    @Override
    public int ab() {
        return this.ab;
    }

    @Override
    @POST
    @Path(value="/cd")
    public String cd() {
        return this.cd;
    }

    @Override
    @GetterAnnotation(policy=RetentionPolicy.CLASS, string="\n\"", type=Object.class, value={@GetterAnnotation.InnerAnnotation, @GetterAnnotation.InnerAnnotation}, bval=-128, dval=Infinity, ival=0x7FFFFFFF, fval=NaNf, blval=true, cval=106)
    @Path(value="/ef")
    public boolean ef() {
        return this.ef;
    }

    public final ImmutableGetters withAb(int value) {
        if (this.ab == value) {
            return this;
        }
        return new ImmutableGetters(value, this.cd, this.ef);
    }

    public final ImmutableGetters withCd(String value) {
        if (this.cd.equals(value)) {
            return this;
        }
        return new ImmutableGetters(this.ab, (String)Preconditions.checkNotNull((Object)value, (Object)"cd"), this.ef);
    }

    public final ImmutableGetters withEf(boolean value) {
        if (this.ef == value) {
            return this;
        }
        return new ImmutableGetters(this.ab, this.cd, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetters && this.equalTo((ImmutableGetters)another);
    }

    private boolean equalTo(ImmutableGetters another) {
        return this.ab == another.ab && this.cd.equals(another.cd);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.ab;
        h = h * 17 + this.cd.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Getters").add("ab", this.ab).add("cd", (Object)this.cd).toString();
    }

    public static ImmutableGetters copyOf(GetterEncloser.Getters instance) {
        if (instance instanceof ImmutableGetters) {
            return (ImmutableGetters)instance;
        }
        return ImmutableGetters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AB = 1L;
        private static final long INIT_BIT_CD = 2L;
        private static final long INIT_BIT_EF = 4L;
        private long initBits = 7L;
        private int ab;
        @Nullable
        private String cd;
        private boolean ef;

        private Builder() {
        }

        public final Builder from(GetterEncloser.Getters instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.ab(instance.ab());
            this.cd(instance.cd());
            this.ef(instance.ef());
            return this;
        }

        public final Builder ab(int ab) {
            this.ab = ab;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder cd(String cd) {
            this.cd = (String)Preconditions.checkNotNull((Object)cd, (Object)"cd");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ef(boolean ef) {
            this.ef = ef;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetters build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetters(this.ab, this.cd, this.ef);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ab");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cd");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ef");
            }
            return "Cannot build Getters, some of required attributes are not set " + attributes;
        }
    }
}

