/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.HasNullable;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableHasNullable
extends HasNullable {
    @Nullable
    private final Integer in;
    @Nullable
    private final String def;
    @Nullable
    private final String der;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final ImmutableHasNullable INSTANCE = ImmutableHasNullable.validate(new ImmutableHasNullable());

    private ImmutableHasNullable() {
        this.in = null;
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    private ImmutableHasNullable(@Nullable Integer in) {
        this.in = in;
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    private ImmutableHasNullable(Builder builder) {
        this.in = builder.in;
        if (builder.def != null) {
            this.initShim.def(builder.def);
        }
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    private ImmutableHasNullable(@Nullable Integer in, @Nullable String def) {
        this.in = in;
        this.def = def;
        this.initShim.def(def);
        this.der = this.initShim.der();
        this.initShim = null;
    }

    @Override
    @Nullable
    public Integer in() {
        return this.in;
    }

    @Override
    @Nullable
    public String def() {
        return this.initShim != null ? this.initShim.def() : this.def;
    }

    @Override
    @Nullable
    public String der() {
        return this.initShim != null ? this.initShim.der() : this.der;
    }

    public final ImmutableHasNullable withIn(@Nullable Integer value) {
        if (Objects.equal((Object)this.in, (Object)value)) {
            return this;
        }
        return ImmutableHasNullable.validate(new ImmutableHasNullable(value, this.def));
    }

    public final ImmutableHasNullable withDef(@Nullable String value) {
        if (Objects.equal((Object)this.def, (Object)value)) {
            return this;
        }
        return ImmutableHasNullable.validate(new ImmutableHasNullable(this.in, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHasNullable && this.equalTo((ImmutableHasNullable)another);
    }

    private boolean equalTo(ImmutableHasNullable another) {
        return Objects.equal((Object)this.in, (Object)another.in) && Objects.equal((Object)this.def, (Object)another.def) && Objects.equal((Object)this.der, (Object)another.der);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.in});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.def});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.der});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HasNullable").add("in", (Object)this.in).add("def", (Object)this.def).add("der", (Object)this.der).toString();
    }

    public static ImmutableHasNullable of() {
        return INSTANCE;
    }

    public static ImmutableHasNullable of(@Nullable Integer in) {
        return ImmutableHasNullable.validate(new ImmutableHasNullable(in));
    }

    private static ImmutableHasNullable validate(ImmutableHasNullable instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableHasNullable copyOf(HasNullable instance) {
        if (instance instanceof ImmutableHasNullable) {
            return (ImmutableHasNullable)instance;
        }
        return ImmutableHasNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer in;
        @Nullable
        private String def;

        private Builder() {
        }

        public final Builder from(HasNullable instance) {
            String defValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Integer inValue = instance.in();
            if (inValue != null) {
                this.in(inValue);
            }
            if ((defValue = instance.def()) != null) {
                this.def(defValue);
            }
            return this;
        }

        public final Builder in(@Nullable Integer in) {
            this.in = in;
            return this;
        }

        public final Builder def(@Nullable String def) {
            this.def = def;
            return this;
        }

        public ImmutableHasNullable build() throws IllegalStateException {
            return ImmutableHasNullable.validate(new ImmutableHasNullable(this));
        }
    }

    private final class InitShim {
        private String def;
        private byte defStage;
        private String der;
        private byte derStage;

        private InitShim() {
        }

        String def() {
            if (this.defStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defStage == 0) {
                this.defStage = (byte)-1;
                this.def = ImmutableHasNullable.super.def();
                this.defStage = 1;
            }
            return this.def;
        }

        String def(String value) {
            this.def = value;
            this.defStage = 1;
            return value;
        }

        String der() {
            if (this.derStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.derStage == 0) {
                this.derStage = (byte)-1;
                this.der = ImmutableHasNullable.super.der();
                this.derStage = 1;
            }
            return this.der;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.defStage == -1) {
                attributes.add("def");
            }
            if (this.derStage == -1) {
                attributes.add("der");
            }
            return "Cannot build HasNullable, attribute initializers form cycle" + attributes;
        }
    }
}

