/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.HostWithPort;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableHostWithPort
extends HostWithPort {
    private final String hostname;
    private final int port;

    private ImmutableHostWithPort(int port, String hostname) {
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
    }

    private ImmutableHostWithPort(ImmutableHostWithPort original, String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public int port() {
        return this.port;
    }

    public final ImmutableHostWithPort withHostname(String value) {
        if (this.hostname.equals(value)) {
            return this;
        }
        return new ImmutableHostWithPort(this, (String)Preconditions.checkNotNull((Object)value, (Object)"hostname"), this.port);
    }

    public final ImmutableHostWithPort withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableHostWithPort(this, this.hostname, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHostWithPort && this.equalTo((ImmutableHostWithPort)another);
    }

    private boolean equalTo(ImmutableHostWithPort another) {
        return this.hostname.equals(another.hostname) && this.port == another.port;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.hostname.hashCode();
        h = h * 17 + this.port;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HostWithPort").add("hostname", (Object)this.hostname).add("port", this.port).toString();
    }

    public static ImmutableHostWithPort of(int port, String hostname) {
        return new ImmutableHostWithPort(port, hostname);
    }

    public static ImmutableHostWithPort copyOf(HostWithPort instance) {
        if (instance instanceof ImmutableHostWithPort) {
            return (ImmutableHostWithPort)instance;
        }
        return ImmutableHostWithPort.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOSTNAME = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private long initBits = 3L;
        @Nullable
        private String hostname;
        private int port;

        private Builder() {
        }

        public final Builder from(HostWithPort instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.hostname(instance.hostname());
            this.port(instance.port());
            return this;
        }

        public final Builder hostname(String hostname) {
            this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableHostWithPort build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHostWithPort(null, this.hostname, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hostname");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build HostWithPort, some of required attributes are not set " + attributes;
        }
    }
}

