/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.IfaceValue;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableIfaceValue
implements IfaceValue {
    private final int number;
    private final ImmutableList<String> auxiliary;
    private final int get;

    private ImmutableIfaceValue(int number) {
        this.number = number;
        this.auxiliary = ImmutableList.of();
        this.get = IfaceValue.super.get();
    }

    private ImmutableIfaceValue(int number, ImmutableList<String> auxiliary) {
        this.number = number;
        this.auxiliary = auxiliary;
        this.get = IfaceValue.super.get();
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public ImmutableList<String> auxiliary() {
        return this.auxiliary;
    }

    @Override
    public int get() {
        return this.get;
    }

    public final ImmutableIfaceValue withNumber(int value) {
        if (this.number == value) {
            return this;
        }
        return new ImmutableIfaceValue(value, this.auxiliary);
    }

    public final ImmutableIfaceValue withAuxiliary(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableIfaceValue(this.number, (ImmutableList<String>)newValue);
    }

    public final ImmutableIfaceValue withAuxiliary(Iterable<String> elements) {
        if (this.auxiliary == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableIfaceValue(this.number, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIfaceValue && this.equalTo((ImmutableIfaceValue)another);
    }

    private boolean equalTo(ImmutableIfaceValue another) {
        return this.number == another.number;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.number;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IfaceValue").add("number", this.number).toString();
    }

    public static ImmutableIfaceValue of(int number) {
        return new ImmutableIfaceValue(number);
    }

    public static ImmutableIfaceValue copyOf(IfaceValue instance) {
        if (instance instanceof ImmutableIfaceValue) {
            return (ImmutableIfaceValue)instance;
        }
        return ImmutableIfaceValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NUMBER = 1L;
        private long initBits = 1L;
        private int number;
        private ImmutableList.Builder<String> auxiliaryBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(IfaceValue instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.number(instance.getNumber());
            this.addAllAuxiliary(instance.auxiliary());
            return this;
        }

        public final Builder number(int number) {
            this.number = number;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAuxiliary(String element) {
            this.auxiliaryBuilder.add((Object)element);
            return this;
        }

        public final Builder addAuxiliary(String ... elements) {
            this.auxiliaryBuilder.add((Object[])elements);
            return this;
        }

        public final Builder auxiliary(Iterable<String> elements) {
            this.auxiliaryBuilder = ImmutableList.builder();
            return this.addAllAuxiliary(elements);
        }

        public final Builder addAllAuxiliary(Iterable<String> elements) {
            this.auxiliaryBuilder.addAll(elements);
            return this;
        }

        public ImmutableIfaceValue build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIfaceValue(this.number, this.auxiliaryBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("number");
            }
            return "Cannot build IfaceValue, some of required attributes are not set " + attributes;
        }
    }
}

