/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.AbstractToStringHashCode;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableInternCustomHashCode
extends AbstractToStringHashCode.InternCustomHashCode {
    private final int a;
    private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

    private ImmutableInternCustomHashCode(int a) {
        this.a = a;
    }

    @Override
    int a() {
        return this.a;
    }

    public final ImmutableInternCustomHashCode withA(int value) {
        if (this.a == value) {
            return this;
        }
        return ImmutableInternCustomHashCode.validate(new ImmutableInternCustomHashCode(value));
    }

    @Override
    public boolean equals(@Nullable Object another) {
        return this == another;
    }

    private boolean equalTo(ImmutableInternCustomHashCode another) {
        return super.equals(another);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InternCustomHashCode").add("a", this.a).toString();
    }

    private static ImmutableInternCustomHashCode validate(ImmutableInternCustomHashCode instance) {
        return ((InternProxy)ImmutableInternCustomHashCode.INTERNER.intern((Object)new InternProxy((ImmutableInternCustomHashCode)instance))).instance;
    }

    public static ImmutableInternCustomHashCode copyOf(AbstractToStringHashCode.InternCustomHashCode instance) {
        if (instance instanceof ImmutableInternCustomHashCode) {
            return (ImmutableInternCustomHashCode)instance;
        }
        return ImmutableInternCustomHashCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        private int a;

        private Builder() {
        }

        public final Builder from(AbstractToStringHashCode.InternCustomHashCode instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.a());
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInternCustomHashCode build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableInternCustomHashCode.validate(new ImmutableInternCustomHashCode(this.a));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build InternCustomHashCode, some of required attributes are not set " + attributes;
        }
    }

    private static class InternProxy {
        final ImmutableInternCustomHashCode instance;

        InternProxy(ImmutableInternCustomHashCode instance) {
            this.instance = instance;
        }

        public boolean equals(@Nullable Object another) {
            return this.instance.equalTo(((InternProxy)another).instance);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

