/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.JavadocDeprecation;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableJavadocDeprecation
implements JavadocDeprecation {
    private final String attr;
    private final ImmutableSet<RetentionPolicy> pols;

    private ImmutableJavadocDeprecation(String attr, ImmutableSet<RetentionPolicy> pols) {
        this.attr = attr;
        this.pols = pols;
    }

    @Override
    @Deprecated
    public String attr() {
        return this.attr;
    }

    @Deprecated
    public ImmutableSet<RetentionPolicy> pols() {
        return this.pols;
    }

    @Deprecated
    public final ImmutableJavadocDeprecation withAttr(String value) {
        if (this.attr.equals(value)) {
            return this;
        }
        return new ImmutableJavadocDeprecation((String)Preconditions.checkNotNull((Object)value, (Object)"attr"), this.pols);
    }

    @Deprecated
    public final ImmutableJavadocDeprecation withPols(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableJavadocDeprecation(this.attr, (ImmutableSet<RetentionPolicy>)newValue);
    }

    @Deprecated
    public final ImmutableJavadocDeprecation withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableJavadocDeprecation(this.attr, (ImmutableSet<RetentionPolicy>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJavadocDeprecation && this.equalTo((ImmutableJavadocDeprecation)another);
    }

    private boolean equalTo(ImmutableJavadocDeprecation another) {
        return this.attr.equals(another.attr) && this.pols.equals(another.pols);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.attr.hashCode();
        h = h * 17 + this.pols.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JavadocDeprecation").add("attr", (Object)this.attr).add("pols", this.pols).toString();
    }

    public static ImmutableJavadocDeprecation copyOf(JavadocDeprecation instance) {
        if (instance instanceof ImmutableJavadocDeprecation) {
            return (ImmutableJavadocDeprecation)instance;
        }
        return ImmutableJavadocDeprecation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ATTR = 1L;
        private long initBits = 1L;
        @Nullable
        private String attr;
        private ImmutableSet.Builder<RetentionPolicy> polsBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder from(JavadocDeprecation instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.attr(instance.attr());
            this.addAllPols(instance.pols());
            return this;
        }

        @Deprecated
        public final Builder attr(String attr) {
            this.attr = (String)Preconditions.checkNotNull((Object)attr, (Object)"attr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        public final Builder addPols(RetentionPolicy element) {
            this.polsBuilder.add((Object)element);
            return this;
        }

        @Deprecated
        public final Builder addPols(RetentionPolicy ... elements) {
            this.polsBuilder.addAll(Arrays.asList(elements));
            return this;
        }

        @Deprecated
        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.polsBuilder = ImmutableSet.builder();
            return this.addAllPols(elements);
        }

        @Deprecated
        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            this.polsBuilder.addAll(elements);
            return this;
        }

        public ImmutableJavadocDeprecation build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJavadocDeprecation(this.attr, Sets.immutableEnumSet((Iterable)this.polsBuilder.build()));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attr");
            }
            return "Cannot build JavadocDeprecation, some of required attributes are not set " + attributes;
        }
    }
}

