/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.JsonIgnore;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableJsonIgnore
implements JsonIgnore {
    private final int value;
    private final ImmutableList<Integer> values;

    private ImmutableJsonIgnore(int value) {
        this.value = value;
        this.values = ImmutableList.of();
    }

    private ImmutableJsonIgnore(int value, ImmutableList<Integer> values) {
        this.value = value;
        this.values = values;
    }

    @Override
    public int value() {
        return this.value;
    }

    public ImmutableList<Integer> values() {
        return this.values;
    }

    public final ImmutableJsonIgnore withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableJsonIgnore(value, this.values);
    }

    public final ImmutableJsonIgnore withValues(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableJsonIgnore(this.value, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableJsonIgnore withValues(Iterable<Integer> elements) {
        if (this.values == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableJsonIgnore(this.value, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonIgnore && this.equalTo((ImmutableJsonIgnore)another);
    }

    private boolean equalTo(ImmutableJsonIgnore another) {
        return this.value == another.value && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value;
        h = h * 17 + this.values.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonIgnore").add("value", this.value).add("values", this.values).toString();
    }

    public static ImmutableJsonIgnore of(int value) {
        return new ImmutableJsonIgnore(value);
    }

    public static ImmutableJsonIgnore copyOf(JsonIgnore instance) {
        if (instance instanceof ImmutableJsonIgnore) {
            return (ImmutableJsonIgnore)instance;
        }
        return ImmutableJsonIgnore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;
        private ImmutableList.Builder<Integer> valuesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(JsonIgnore instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.value(instance.value());
            this.addAllValues(instance.values());
            return this;
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addValues(int element) {
            this.valuesBuilder.add((Object)element);
            return this;
        }

        public final Builder addValues(int ... elements) {
            this.valuesBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder values(Iterable<Integer> elements) {
            this.valuesBuilder = ImmutableList.builder();
            return this.addAllValues(elements);
        }

        public final Builder addAllValues(Iterable<Integer> elements) {
            this.valuesBuilder.addAll(elements);
            return this;
        }

        public ImmutableJsonIgnore build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonIgnore(this.value, this.valuesBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build JsonIgnore, some of required attributes are not set " + attributes;
        }
    }
}

