/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.UnderwriteObjectMethods;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableNoUnderwrite
extends UnderwriteObjectMethods.NoUnderwrite {
    private final int value;

    private ImmutableNoUnderwrite(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    public final ImmutableNoUnderwrite withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableNoUnderwrite(value);
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNoUnderwrite && this.equalTo((ImmutableNoUnderwrite)another);
    }

    private boolean equalTo(ImmutableNoUnderwrite another) {
        return this.value == another.value;
    }

    @Override
    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value;
        return h;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"NoUnderwrite").add("value", this.value).toString();
    }

    public static ImmutableNoUnderwrite copyOf(UnderwriteObjectMethods.NoUnderwrite instance) {
        if (instance instanceof ImmutableNoUnderwrite) {
            return (ImmutableNoUnderwrite)instance;
        }
        return ImmutableNoUnderwrite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;

        private Builder() {
        }

        public final Builder from(UnderwriteObjectMethods.AbstractNoUnderwrite instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UnderwriteObjectMethods.NoUnderwrite instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UnderwriteObjectMethods.AbstractNoUnderwrite instance;
            long bits = 0L;
            if (object instanceof UnderwriteObjectMethods.AbstractNoUnderwrite) {
                instance = (UnderwriteObjectMethods.AbstractNoUnderwrite)object;
                if ((bits & 1L) == 0L) {
                    this.value(instance.value());
                    bits |= 1L;
                }
            }
            if (object instanceof UnderwriteObjectMethods.NoUnderwrite) {
                instance = (UnderwriteObjectMethods.NoUnderwrite)object;
                if ((bits & 1L) == 0L) {
                    this.value(((UnderwriteObjectMethods.NoUnderwrite)instance).value());
                    bits |= 1L;
                }
            }
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNoUnderwrite build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNoUnderwrite(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build NoUnderwrite, some of required attributes are not set " + attributes;
        }
    }
}

