/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.NullableArray;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableNullableArray
implements NullableArray {
    @Nullable
    private final byte[] array;

    private ImmutableNullableArray(@Nullable byte[] array) {
        this.array = array;
    }

    @Override
    @Nullable
    public byte[] array() {
        return this.array == null ? null : (byte[])this.array.clone();
    }

    public final ImmutableNullableArray withArray(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableNullableArray(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableArray && this.equalTo((ImmutableNullableArray)another);
    }

    private boolean equalTo(ImmutableNullableArray another) {
        return Arrays.equals(this.array, another.array);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Arrays.hashCode(this.array);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableArray").add("array", (Object)Arrays.toString(this.array)).toString();
    }

    public static ImmutableNullableArray copyOf(NullableArray instance) {
        if (instance instanceof ImmutableNullableArray) {
            return (ImmutableNullableArray)instance;
        }
        return ImmutableNullableArray.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private byte[] array;

        private Builder() {
        }

        public final Builder from(NullableArray instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            byte[] arrayValue = instance.array();
            if (arrayValue != null) {
                this.array(arrayValue);
            }
            return this;
        }

        public final Builder array(byte ... elements) {
            if (elements == null) {
                return this;
            }
            this.array = (byte[])elements.clone();
            return this;
        }

        public ImmutableNullableArray build() throws IllegalStateException {
            return new ImmutableNullableArray(this.array);
        }
    }
}

