/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.NullableRef;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableNullableRef
extends NullableRef {
    @Nullable
    private final Object[] refs;

    private ImmutableNullableRef(@Nullable Object[] refs) {
        this.refs = refs;
    }

    @Override
    @Nullable
    Object[] refs() {
        return this.refs == null ? null : (Object[])this.refs.clone();
    }

    public final ImmutableNullableRef withRefs(Object ... elements) {
        Object[] newValue = elements == null ? null : (Object[])elements.clone();
        return new ImmutableNullableRef(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableRef && this.equalTo((ImmutableNullableRef)another);
    }

    private boolean equalTo(ImmutableNullableRef another) {
        return Arrays.equals(this.refs, another.refs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Arrays.hashCode(this.refs);
        return h;
    }

    public String toString() {
        return "NullableRef{refs=" + Arrays.toString(this.refs) + "}";
    }

    public static ImmutableNullableRef copyOf(NullableRef instance) {
        if (instance instanceof ImmutableNullableRef) {
            return (ImmutableNullableRef)instance;
        }
        return ImmutableNullableRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        @Nullable
        private Object[] refs;

        private Builder() {
        }

        public final Builder from(NullableRef instance) {
            Objects.requireNonNull(instance, "instance");
            Object[] refsValue = instance.refs();
            if (refsValue != null) {
                this.refs(refsValue);
            }
            return this;
        }

        public final Builder refs(Object ... elements) {
            if (elements == null) {
                return this;
            }
            this.refs = (Object[])elements.clone();
            return this;
        }

        public ImmutableNullableRef build() throws IllegalStateException {
            return new ImmutableNullableRef(this.refs);
        }
    }
}

