/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.OrderAttributeValue;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableOrderAttributeValue
extends OrderAttributeValue {
    private final ImmutableSortedSet<Integer> natural;
    private final ImmutableSortedSet<String> reverse;
    private final ImmutableSortedMap<String, String> reverseMap;
    private final ImmutableSortedMap<Integer, String> navigableMap;

    private ImmutableOrderAttributeValue(ImmutableSortedSet<Integer> natural, ImmutableSortedSet<String> reverse, ImmutableSortedMap<String, String> reverseMap, ImmutableSortedMap<Integer, String> navigableMap) {
        this.natural = natural;
        this.reverse = reverse;
        this.reverseMap = reverseMap;
        this.navigableMap = navigableMap;
    }

    public ImmutableSortedSet<Integer> natural() {
        return this.natural;
    }

    public ImmutableSortedSet<String> reverse() {
        return this.reverse;
    }

    public ImmutableSortedMap<String, String> reverseMap() {
        return this.reverseMap;
    }

    public ImmutableSortedMap<Integer, String> navigableMap() {
        return this.navigableMap;
    }

    public final ImmutableOrderAttributeValue withNatural(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), (Collection)Ints.asList((int[])elements));
        return new ImmutableOrderAttributeValue((ImmutableSortedSet<Integer>)newValue, this.reverse, this.reverseMap, this.navigableMap);
    }

    public final ImmutableOrderAttributeValue withNatural(Iterable<Integer> elements) {
        if (this.natural == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableOrderAttributeValue((ImmutableSortedSet<Integer>)newValue, this.reverse, this.reverseMap, this.navigableMap);
    }

    public final ImmutableOrderAttributeValue withReverse(String ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), Arrays.asList(elements));
        return new ImmutableOrderAttributeValue(this.natural, (ImmutableSortedSet<String>)newValue, this.reverseMap, this.navigableMap);
    }

    public final ImmutableOrderAttributeValue withReverse(Iterable<String> elements) {
        if (this.reverse == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableOrderAttributeValue(this.natural, (ImmutableSortedSet<String>)newValue, this.reverseMap, this.navigableMap);
    }

    public final ImmutableOrderAttributeValue withReverseMap(Map<String, ? extends String> entries) {
        if (this.reverseMap == entries) {
            return this;
        }
        ImmutableSortedMap value = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural().reverse());
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, (ImmutableSortedMap<String, String>)value, this.navigableMap);
    }

    public final ImmutableOrderAttributeValue withNavigableMap(Map<Integer, ? extends String> entries) {
        if (this.navigableMap == entries) {
            return this;
        }
        ImmutableSortedMap value = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, (ImmutableSortedMap<Integer, String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOrderAttributeValue && this.equalTo((ImmutableOrderAttributeValue)another);
    }

    private boolean equalTo(ImmutableOrderAttributeValue another) {
        return this.natural.equals(another.natural) && this.reverse.equals(another.reverse) && this.reverseMap.equals(another.reverseMap) && this.navigableMap.equals(another.navigableMap);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.natural.hashCode();
        h = h * 17 + this.reverse.hashCode();
        h = h * 17 + this.reverseMap.hashCode();
        h = h * 17 + this.navigableMap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OrderAttributeValue").add("natural", this.natural).add("reverse", this.reverse).add("reverseMap", this.reverseMap).add("navigableMap", this.navigableMap).toString();
    }

    public static ImmutableOrderAttributeValue copyOf(OrderAttributeValue instance) {
        if (instance instanceof ImmutableOrderAttributeValue) {
            return (ImmutableOrderAttributeValue)instance;
        }
        return ImmutableOrderAttributeValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableSortedSet.Builder<Integer> naturalBuilder = ImmutableSortedSet.naturalOrder();
        private ImmutableSortedSet.Builder<String> reverseBuilder = ImmutableSortedSet.reverseOrder();
        private ImmutableSortedMap.Builder<String, String> reverseMapBuilder = ImmutableSortedMap.reverseOrder();
        private ImmutableSortedMap.Builder<Integer, String> navigableMapBuilder = ImmutableSortedMap.naturalOrder();

        private Builder() {
        }

        public final Builder from(OrderAttributeValue instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllNatural(instance.natural());
            this.addAllReverse(instance.reverse());
            this.putAllReverseMap(instance.reverseMap());
            this.putAllNavigableMap(instance.navigableMap());
            return this;
        }

        public final Builder addNatural(int element) {
            this.naturalBuilder.add((Object)element);
            return this;
        }

        public final Builder addNatural(int ... elements) {
            this.naturalBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder natural(Iterable<Integer> elements) {
            this.naturalBuilder = ImmutableSortedSet.naturalOrder();
            return this.addAllNatural(elements);
        }

        public final Builder addAllNatural(Iterable<Integer> elements) {
            this.naturalBuilder.addAll(elements);
            return this;
        }

        public final Builder addReverse(String element) {
            this.reverseBuilder.add((Object)element);
            return this;
        }

        public final Builder addReverse(String ... elements) {
            this.reverseBuilder.addAll(Arrays.asList(elements));
            return this;
        }

        public final Builder reverse(Iterable<String> elements) {
            this.reverseBuilder = ImmutableSortedSet.reverseOrder();
            return this.addAllReverse(elements);
        }

        public final Builder addAllReverse(Iterable<String> elements) {
            this.reverseBuilder.addAll(elements);
            return this;
        }

        public final Builder putReverseMap(String key, String value) {
            this.reverseMapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putReverseMap(Map.Entry<String, ? extends String> entry) {
            this.reverseMapBuilder.put(entry);
            return this;
        }

        public final Builder reverseMap(Map<String, ? extends String> entries) {
            this.reverseMapBuilder = ImmutableSortedMap.reverseOrder();
            return this.putAllReverseMap(entries);
        }

        public final Builder putAllReverseMap(Map<String, ? extends String> entries) {
            this.reverseMapBuilder.putAll(entries);
            return this;
        }

        public final Builder putNavigableMap(int key, String value) {
            this.navigableMapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putNavigableMap(Map.Entry<Integer, ? extends String> entry) {
            this.navigableMapBuilder.put(entry);
            return this;
        }

        public final Builder navigableMap(Map<Integer, ? extends String> entries) {
            this.navigableMapBuilder = ImmutableSortedMap.naturalOrder();
            return this.putAllNavigableMap(entries);
        }

        public final Builder putAllNavigableMap(Map<Integer, ? extends String> entries) {
            this.navigableMapBuilder.putAll(entries);
            return this;
        }

        public ImmutableOrderAttributeValue build() throws IllegalStateException {
            return new ImmutableOrderAttributeValue(this.naturalBuilder.build(), this.reverseBuilder.build(), this.reverseMapBuilder.build(), this.navigableMapBuilder.build());
        }
    }
}

