/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.HidingImplementation;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutablePoint
extends HidingImplementation.Point {
    private final double x;
    private final double y;

    private ImmutablePoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    public final ImmutablePoint withX(double value) {
        if (Double.doubleToLongBits(this.x) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePoint(value, this.y);
    }

    public final ImmutablePoint withY(double value) {
        if (Double.doubleToLongBits(this.y) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePoint(this.x, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePoint && this.equalTo((ImmutablePoint)another);
    }

    private boolean equalTo(ImmutablePoint another) {
        return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(another.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(another.y);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Doubles.hashCode((double)this.x);
        h = h * 17 + Doubles.hashCode((double)this.y);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Point").add("x", this.x).add("y", this.y).toString();
    }

    public static ImmutablePoint of(double x, double y) {
        return new ImmutablePoint(x, y);
    }

    public static ImmutablePoint copyOf(HidingImplementation.Point instance) {
        if (instance instanceof ImmutablePoint) {
            return (ImmutablePoint)instance;
        }
        return ImmutablePoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder
    implements HidingImplementation.Point.Builder {
        private static final long INIT_BIT_X = 1L;
        private static final long INIT_BIT_Y = 2L;
        private long initBits = 3L;
        private double x;
        private double y;

        private Builder() {
        }

        public final Builder from(HidingImplementation.Point instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.x(instance.x());
            this.y(instance.y());
            return this;
        }

        @Override
        public final Builder x(double x) {
            this.x = x;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder y(double y) {
            this.y = y;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutablePoint build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePoint(this.x, this.y);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("x");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("y");
            }
            return "Cannot build Point, some of required attributes are not set " + attributes;
        }
    }
}

