/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SafeDerivedInit;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSafeInitIface
implements SafeDerivedInit.SafeInitIface {
    private final int b;
    private final int a;
    private final int c;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();

    private ImmutableSafeInitIface(Builder builder) {
        if (builder.bIsSet()) {
            this.initShim.b(builder.b);
        }
        if (builder.aIsSet()) {
            this.initShim.a(builder.a);
        }
        if (builder.cIsSet()) {
            this.initShim.c(builder.c);
        }
        this.b = this.initShim.b();
        this.a = this.initShim.a();
        this.c = this.initShim.c();
        this.initShim = null;
    }

    private ImmutableSafeInitIface(int b, int a, int c) {
        this.b = b;
        this.a = a;
        this.c = c;
        this.initShim.b(b);
        this.initShim.a(a);
        this.initShim.c(c);
        this.initShim = null;
    }

    private int bInitialize() {
        return SafeDerivedInit.SafeInitIface.super.b();
    }

    private int aInitialize() {
        return SafeDerivedInit.SafeInitIface.super.a();
    }

    private int cInitialize() {
        return SafeDerivedInit.SafeInitIface.super.c();
    }

    @Override
    public int b() {
        return this.initShim != null ? this.initShim.b() : this.b;
    }

    @Override
    public int a() {
        return this.initShim != null ? this.initShim.a() : this.a;
    }

    @Override
    public int c() {
        return this.initShim != null ? this.initShim.c() : this.c;
    }

    public final ImmutableSafeInitIface withB(int value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableSafeInitIface(value, this.a, this.c);
    }

    public final ImmutableSafeInitIface withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableSafeInitIface(this.b, value, this.c);
    }

    public final ImmutableSafeInitIface withC(int value) {
        if (this.c == value) {
            return this;
        }
        return new ImmutableSafeInitIface(this.b, this.a, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSafeInitIface && this.equalTo((ImmutableSafeInitIface)another);
    }

    private boolean equalTo(ImmutableSafeInitIface another) {
        return this.b == another.b && this.a == another.a && this.c == another.c;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.b;
        h = h * 17 + this.a;
        h = h * 17 + this.c;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SafeInitIface").add("b", this.b).add("a", this.a).add("c", this.c).toString();
    }

    public static ImmutableSafeInitIface copyOf(SafeDerivedInit.SafeInitIface instance) {
        if (instance instanceof ImmutableSafeInitIface) {
            return (ImmutableSafeInitIface)instance;
        }
        return ImmutableSafeInitIface.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_B = 1L;
        private static final long OPT_BIT_A = 2L;
        private static final long OPT_BIT_C = 4L;
        private long optBits;
        private int b;
        private int a;
        private int c;

        private Builder() {
        }

        public final Builder from(SafeDerivedInit.SafeInitIface instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.b(instance.b());
            this.a(instance.a());
            this.c(instance.c());
            return this;
        }

        public final Builder b(int b) {
            this.b = b;
            this.optBits |= 1L;
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.optBits |= 2L;
            return this;
        }

        public final Builder c(int c) {
            this.c = c;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableSafeInitIface build() throws IllegalStateException {
            return new ImmutableSafeInitIface(this);
        }

        private boolean bIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean aIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean cIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private int b;
        private byte bStage;
        private int a;
        private byte aStage;
        private int c;
        private byte cStage;

        private InitShim() {
        }

        int b() {
            if (this.bStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bStage == 0) {
                this.bStage = (byte)-1;
                this.b = ImmutableSafeInitIface.this.bInitialize();
                this.bStage = 1;
            }
            return this.b;
        }

        int b(int value) {
            this.b = value;
            this.bStage = 1;
            return value;
        }

        int a() {
            if (this.aStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aStage == 0) {
                this.aStage = (byte)-1;
                this.a = ImmutableSafeInitIface.this.aInitialize();
                this.aStage = 1;
            }
            return this.a;
        }

        int a(int value) {
            this.a = value;
            this.aStage = 1;
            return value;
        }

        int c() {
            if (this.cStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cStage == 0) {
                this.cStage = (byte)-1;
                this.c = ImmutableSafeInitIface.this.cInitialize();
                this.cStage = 1;
            }
            return this.c;
        }

        int c(int value) {
            this.c = value;
            this.cStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.bStage == -1) {
                attributes.add("b");
            }
            if (this.aStage == -1) {
                attributes.add("a");
            }
            if (this.cStage == -1) {
                attributes.add("c");
            }
            return "Cannot build SafeInitIface, attribute initializers form cycle" + attributes;
        }
    }
}

