/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SafeDerivedInit;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSafeInitSingl
implements SafeDerivedInit.SafeInitSingl {
    private final int a;
    private final int b;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final ImmutableSafeInitSingl INSTANCE = ImmutableSafeInitSingl.validate(new ImmutableSafeInitSingl());

    private ImmutableSafeInitSingl() {
        this.a = this.initShim.a();
        this.b = this.initShim.b();
        this.initShim = null;
    }

    private ImmutableSafeInitSingl(Builder builder) {
        if (builder.aIsSet()) {
            this.initShim.a(builder.a);
        }
        this.a = this.initShim.a();
        this.b = this.initShim.b();
        this.initShim = null;
    }

    private ImmutableSafeInitSingl(int a) {
        this.a = a;
        this.initShim.a(a);
        this.b = this.initShim.b();
        this.initShim = null;
    }

    private int aInitialize() {
        return SafeDerivedInit.SafeInitSingl.super.a();
    }

    private int bInitialize() {
        return SafeDerivedInit.SafeInitSingl.super.b();
    }

    @Override
    public int a() {
        return this.initShim != null ? this.initShim.a() : this.a;
    }

    @Override
    public int b() {
        return this.initShim != null ? this.initShim.b() : this.b;
    }

    public final ImmutableSafeInitSingl withA(int value) {
        if (this.a == value) {
            return this;
        }
        return ImmutableSafeInitSingl.validate(new ImmutableSafeInitSingl(value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSafeInitSingl && this.equalTo((ImmutableSafeInitSingl)another);
    }

    private boolean equalTo(ImmutableSafeInitSingl another) {
        return this.a == another.a && this.b == another.b;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a;
        h = h * 17 + this.b;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SafeInitSingl").add("a", this.a).add("b", this.b).toString();
    }

    public static ImmutableSafeInitSingl of() {
        return INSTANCE;
    }

    private static ImmutableSafeInitSingl validate(ImmutableSafeInitSingl instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableSafeInitSingl copyOf(SafeDerivedInit.SafeInitSingl instance) {
        if (instance instanceof ImmutableSafeInitSingl) {
            return (ImmutableSafeInitSingl)instance;
        }
        return ImmutableSafeInitSingl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_A = 1L;
        private long optBits;
        private int a;

        private Builder() {
        }

        public final Builder from(SafeDerivedInit.SafeInitSingl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.a());
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSafeInitSingl build() throws IllegalStateException {
            return ImmutableSafeInitSingl.validate(new ImmutableSafeInitSingl(this));
        }

        private boolean aIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    private final class InitShim {
        private int a;
        private byte aStage;
        private int b;
        private byte bStage;

        private InitShim() {
        }

        int a() {
            if (this.aStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aStage == 0) {
                this.aStage = (byte)-1;
                this.a = ImmutableSafeInitSingl.this.aInitialize();
                this.aStage = 1;
            }
            return this.a;
        }

        int a(int value) {
            this.a = value;
            this.aStage = 1;
            return value;
        }

        int b() {
            if (this.bStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bStage == 0) {
                this.bStage = (byte)-1;
                this.b = ImmutableSafeInitSingl.this.bInitialize();
                this.bStage = 1;
            }
            return this.b;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.aStage == -1) {
                attributes.add("a");
            }
            if (this.bStage == -1) {
                attributes.add("b");
            }
            return "Cannot build SafeInitSingl, attribute initializers form cycle" + attributes;
        }
    }
}

