/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SampleCopyOfTypes;

@ParametersAreNonnullByDefault
public final class ImmutableSampleCopyOfTypes {
    private ImmutableSampleCopyOfTypes() {
    }

    @Immutable
    public static final class ByConstructorAndWithers
    implements SampleCopyOfTypes.ByConstructorAndWithers {
        private final int value;
        private final ImmutableList<String> additional;

        private ByConstructorAndWithers(int value) {
            this.value = value;
            this.additional = ImmutableList.of();
        }

        private ByConstructorAndWithers(int value, ImmutableList<String> additional) {
            this.value = value;
            this.additional = additional;
        }

        @Override
        public int value() {
            return this.value;
        }

        public ImmutableList<String> additional() {
            return this.additional;
        }

        public final ByConstructorAndWithers withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new ByConstructorAndWithers(value, this.additional);
        }

        public final ByConstructorAndWithers withAdditional(String ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new ByConstructorAndWithers(this.value, (ImmutableList<String>)newValue);
        }

        public final ByConstructorAndWithers withAdditional(Iterable<String> elements) {
            if (this.additional == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new ByConstructorAndWithers(this.value, (ImmutableList<String>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ByConstructorAndWithers && this.equalTo((ByConstructorAndWithers)another);
        }

        private boolean equalTo(ByConstructorAndWithers another) {
            return this.value == another.value && this.additional.equals(another.additional);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.value;
            h = h * 17 + this.additional.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ByConstructorAndWithers").add("value", this.value).add("additional", this.additional).toString();
        }

        public static ByConstructorAndWithers of(int value) {
            return new ByConstructorAndWithers(value);
        }

        public static ByConstructorAndWithers copyOf(SampleCopyOfTypes.ByConstructorAndWithers instance) {
            if (instance instanceof ByConstructorAndWithers) {
                return (ByConstructorAndWithers)instance;
            }
            return ByConstructorAndWithers.of(instance.value()).withAdditional(instance.additional());
        }
    }

    @Immutable
    public static final class ByBuilder
    implements SampleCopyOfTypes.ByBuilder {
        private final int value;

        private ByBuilder(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }

        public final ByBuilder withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new ByBuilder(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ByBuilder && this.equalTo((ByBuilder)another);
        }

        private boolean equalTo(ByBuilder another) {
            return this.value == another.value;
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.value;
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ByBuilder").add("value", this.value).toString();
        }

        public static ByBuilder copyOf(SampleCopyOfTypes.ByBuilder instance) {
            if (instance instanceof ByBuilder) {
                return (ByBuilder)instance;
            }
            return ByBuilder.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private long initBits = 1L;
            private int value;

            private Builder() {
            }

            public final Builder from(SampleCopyOfTypes.ByBuilder instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.value(instance.value());
                return this;
            }

            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ByBuilder build() throws IllegalStateException {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ByBuilder(this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build ByBuilder, some of required attributes are not set " + attributes;
            }
        }
    }
}

