/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SampleValue;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSampleValue
implements SampleValue {
    private final int a;
    private final ImmutableList<Integer> c;
    @Nullable
    private final Integer oi;
    private final Optional<String> os;

    private ImmutableSampleValue(int a, ImmutableList<Integer> c, @Nullable Integer oi, Optional<String> os) {
        this.a = a;
        this.c = c;
        this.oi = oi;
        this.os = os;
    }

    @Override
    public int a() {
        return this.a;
    }

    public ImmutableList<Integer> c() {
        return this.c;
    }

    @Override
    public OptionalInt oi() {
        return this.oi != null ? OptionalInt.of(this.oi) : OptionalInt.empty();
    }

    @Override
    public Optional<String> os() {
        return this.os;
    }

    public final ImmutableSampleValue withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableSampleValue(value, this.c, this.oi, this.os);
    }

    public final ImmutableSampleValue withC(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableSampleValue(this.a, (ImmutableList<Integer>)newValue, this.oi, this.os);
    }

    public final ImmutableSampleValue withC(Iterable<Integer> elements) {
        if (this.c == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSampleValue(this.a, (ImmutableList<Integer>)newValue, this.oi, this.os);
    }

    public final ImmutableSampleValue withOi(int value) {
        Integer newValue = value;
        if (this.oi == newValue) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, newValue, this.os);
    }

    public final ImmutableSampleValue withOi(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (this.oi == value) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, value, this.os);
    }

    public final ImmutableSampleValue withOs(String value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableSampleValue(this.a, this.c, this.oi, (Optional<String>)newValue);
    }

    public final ImmutableSampleValue withOs(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"os");
        if (this.os == value) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, this.oi, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSampleValue && this.equalTo((ImmutableSampleValue)another);
    }

    private boolean equalTo(ImmutableSampleValue another) {
        return this.a == another.a && this.c.equals(another.c) && Objects.equal((Object)this.oi, (Object)another.oi) && this.os.equals(another.os);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a;
        h = h * 17 + this.c.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.oi});
        h = h * 17 + this.os.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SampleValue").add("a", this.a).add("c", this.c).add("oi", (Object)this.oi()).add("os", this.os).toString();
    }

    public static ImmutableSampleValue copyOf(SampleValue instance) {
        if (instance instanceof ImmutableSampleValue) {
            return (ImmutableSampleValue)instance;
        }
        return ImmutableSampleValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        private int a;
        private ImmutableList.Builder<Integer> cBuilder = ImmutableList.builder();
        @Nullable
        private Integer oi;
        private Optional<String> os = Optional.absent();

        private Builder() {
        }

        public final Builder from(SampleValue instance) {
            Optional<String> osOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.a());
            this.addAllC(instance.c());
            OptionalInt oiOptional = instance.oi();
            if (oiOptional.isPresent()) {
                this.oi(oiOptional);
            }
            if ((osOptional = instance.os()).isPresent()) {
                this.os(osOptional);
            }
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addC(int element) {
            this.cBuilder.add((Object)element);
            return this;
        }

        public final Builder addC(int ... elements) {
            this.cBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder c(Iterable<Integer> elements) {
            this.cBuilder = ImmutableList.builder();
            return this.addAllC(elements);
        }

        public final Builder addAllC(Iterable<Integer> elements) {
            this.cBuilder.addAll(elements);
            return this;
        }

        public final Builder oi(int oi) {
            this.oi = oi;
            return this;
        }

        public final Builder oi(OptionalInt oi) {
            this.oi = oi.isPresent() ? Integer.valueOf(oi.getAsInt()) : null;
            return this;
        }

        public final Builder os(String os) {
            this.os = Optional.of((Object)os);
            return this;
        }

        public final Builder os(Optional<String> os) {
            this.os = (Optional)Preconditions.checkNotNull(os, (Object)"os");
            return this;
        }

        public ImmutableSampleValue build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSampleValue(this.a, this.cBuilder.build(), this.oi, this.os);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build SampleValue, some of required attributes are not set " + attributes;
        }
    }
}

