/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyEntity;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyEntity
extends SillyEntity {
    private final int id;
    private final String val;
    private final ImmutableMap<String, Integer> payload;
    private final ImmutableList<Integer> ints;
    private final UnsignedInteger der;

    private ImmutableSillyEntity(int id, String val, ImmutableMap<String, Integer> payload, ImmutableList<Integer> ints) {
        this.id = id;
        this.val = val;
        this.payload = payload;
        this.ints = ints;
        this.der = (UnsignedInteger)Preconditions.checkNotNull((Object)super.der(), (Object)"der");
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String val() {
        return this.val;
    }

    public ImmutableMap<String, Integer> payload() {
        return this.payload;
    }

    public ImmutableList<Integer> ints() {
        return this.ints;
    }

    @Override
    public UnsignedInteger der() {
        return this.der;
    }

    public final ImmutableSillyEntity withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableSillyEntity(value, this.val, this.payload, this.ints);
    }

    public final ImmutableSillyEntity withVal(String value) {
        if (this.val.equals(value)) {
            return this;
        }
        return new ImmutableSillyEntity(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"val"), this.payload, this.ints);
    }

    public final ImmutableSillyEntity withPayload(Map<String, ? extends Integer> entries) {
        if (this.payload == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableSillyEntity(this.id, this.val, (ImmutableMap<String, Integer>)value, this.ints);
    }

    public final ImmutableSillyEntity withInts(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableSillyEntity(this.id, this.val, this.payload, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableSillyEntity withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSillyEntity(this.id, this.val, this.payload, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyEntity && this.equalTo((ImmutableSillyEntity)another);
    }

    private boolean equalTo(ImmutableSillyEntity another) {
        return this.id == another.id && this.val.equals(another.val) && this.payload.equals(another.payload) && this.ints.equals(another.ints) && this.der.equals((Object)another.der);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.val.hashCode();
        h = h * 17 + this.payload.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + this.der.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyEntity").add("id", this.id).add("val", (Object)this.val).add("payload", this.payload).add("ints", this.ints).add("der", (Object)this.der).toString();
    }

    public static ImmutableSillyEntity copyOf(SillyEntity instance) {
        if (instance instanceof ImmutableSillyEntity) {
            return (ImmutableSillyEntity)instance;
        }
        return ImmutableSillyEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VAL = 2L;
        private long initBits = 3L;
        private int id;
        @Nullable
        private String val;
        private ImmutableMap.Builder<String, Integer> payloadBuilder = ImmutableMap.builder();
        private ImmutableList.Builder<Integer> intsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(SillyEntity instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.id());
            this.val(instance.val());
            this.putAllPayload(instance.payload());
            this.addAllInts(instance.ints());
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder val(String val) {
            this.val = (String)Preconditions.checkNotNull((Object)val, (Object)"val");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putPayload(String key, int value) {
            this.payloadBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putPayload(Map.Entry<String, ? extends Integer> entry) {
            this.payloadBuilder.put(entry);
            return this;
        }

        public final Builder payload(Map<String, ? extends Integer> entries) {
            this.payloadBuilder = ImmutableMap.builder();
            return this.putAllPayload(entries);
        }

        public final Builder putAllPayload(Map<String, ? extends Integer> entries) {
            this.payloadBuilder.putAll(entries);
            return this;
        }

        public final Builder addInts(int element) {
            this.intsBuilder.add((Object)element);
            return this;
        }

        public final Builder addInts(int ... elements) {
            this.intsBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder ints(Iterable<Integer> elements) {
            this.intsBuilder = ImmutableList.builder();
            return this.addAllInts(elements);
        }

        public final Builder addAllInts(Iterable<Integer> elements) {
            this.intsBuilder.addAll(elements);
            return this;
        }

        public ImmutableSillyEntity build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSillyEntity(this.id, this.val, this.payloadBuilder.build(), this.intsBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("val");
            }
            return "Cannot build SillyEntity, some of required attributes are not set " + attributes;
        }
    }
}

