/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyEntitySecond;
import org.immutables.mongo.types.Id;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyEntitySecond
extends SillyEntitySecond {
    private final Id id;

    private ImmutableSillyEntitySecond(Builder builder) {
        this.id = builder.id != null ? builder.id : (Id)Preconditions.checkNotNull((Object)super.id(), (Object)"id");
    }

    private ImmutableSillyEntitySecond(Id id) {
        this.id = id;
    }

    @Override
    public Id id() {
        return this.id;
    }

    public final ImmutableSillyEntitySecond withId(Id value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableSillyEntitySecond((Id)Preconditions.checkNotNull((Object)value, (Object)"id"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyEntitySecond && this.equalTo((ImmutableSillyEntitySecond)another);
    }

    private boolean equalTo(ImmutableSillyEntitySecond another) {
        return this.id.equals((Object)another.id);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyEntitySecond").add("id", (Object)this.id).toString();
    }

    public static ImmutableSillyEntitySecond copyOf(SillyEntitySecond instance) {
        if (instance instanceof ImmutableSillyEntitySecond) {
            return (ImmutableSillyEntitySecond)instance;
        }
        return ImmutableSillyEntitySecond.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Id id;

        private Builder() {
        }

        public final Builder from(SillyEntitySecond instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.id());
            return this;
        }

        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public ImmutableSillyEntitySecond build() throws IllegalStateException {
            return new ImmutableSillyEntitySecond(this);
        }
    }
}

