/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyInterned;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyInterned
extends SillyInterned {
    private final int arg1;
    private final int arg2;
    private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

    private ImmutableSillyInterned(int arg1, int arg2) {
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    private ImmutableSillyInterned(ImmutableSillyInterned original, int arg1, int arg2) {
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public int arg1() {
        return this.arg1;
    }

    @Override
    public int arg2() {
        return this.arg2;
    }

    public final ImmutableSillyInterned withArg1(int value) {
        if (this.arg1 == value) {
            return this;
        }
        return ImmutableSillyInterned.validate(new ImmutableSillyInterned(this, value, this.arg2));
    }

    public final ImmutableSillyInterned withArg2(int value) {
        if (this.arg2 == value) {
            return this;
        }
        return ImmutableSillyInterned.validate(new ImmutableSillyInterned(this, this.arg1, value));
    }

    public boolean equals(@Nullable Object another) {
        return this == another;
    }

    private boolean equalTo(ImmutableSillyInterned another) {
        return this.arg1 == another.arg1 && this.arg2 == another.arg2;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.arg1;
        h = h * 17 + this.arg2;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyInterned").add("arg1", this.arg1).add("arg2", this.arg2).toString();
    }

    public static ImmutableSillyInterned of(int arg1, int arg2) {
        return ImmutableSillyInterned.validate(new ImmutableSillyInterned(arg1, arg2));
    }

    private static ImmutableSillyInterned validate(ImmutableSillyInterned instance) {
        return ((InternProxy)ImmutableSillyInterned.INTERNER.intern((Object)new InternProxy((ImmutableSillyInterned)instance))).instance;
    }

    public static ImmutableSillyInterned copyOf(SillyInterned instance) {
        if (instance instanceof ImmutableSillyInterned) {
            return (ImmutableSillyInterned)instance;
        }
        return ImmutableSillyInterned.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARG1 = 1L;
        private static final long INIT_BIT_ARG2 = 2L;
        private long initBits = 3L;
        private int arg1;
        private int arg2;

        private Builder() {
        }

        public final Builder from(SillyInterned instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.arg1(instance.arg1());
            this.arg2(instance.arg2());
            return this;
        }

        public final Builder arg1(int arg1) {
            this.arg1 = arg1;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder arg2(int arg2) {
            this.arg2 = arg2;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSillyInterned build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSillyInterned.validate(new ImmutableSillyInterned(null, this.arg1, this.arg2));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("arg1");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arg2");
            }
            return "Cannot build SillyInterned, some of required attributes are not set " + attributes;
        }
    }

    private static class InternProxy {
        final ImmutableSillyInterned instance;

        InternProxy(ImmutableSillyInterned instance) {
            this.instance = instance;
        }

        public boolean equals(@Nullable Object another) {
            return this.instance.equalTo(((InternProxy)another).instance);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

