/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyLazy;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyLazy
extends SillyLazy {
    private final AtomicInteger counter;
    private volatile long lazyInitBitmap;
    private static final long VAL1_LAZY_INIT_BIT = 1L;
    private int val1;
    private static final long VAL2_LAZY_INIT_BIT = 2L;
    private int val2;

    private ImmutableSillyLazy(AtomicInteger counter) {
        this.counter = (AtomicInteger)Preconditions.checkNotNull((Object)counter, (Object)"counter");
    }

    private ImmutableSillyLazy(ImmutableSillyLazy original, AtomicInteger counter) {
        this.counter = counter;
    }

    @Override
    public AtomicInteger counter() {
        return this.counter;
    }

    public final ImmutableSillyLazy withCounter(AtomicInteger value) {
        if (this.counter == value) {
            return this;
        }
        return new ImmutableSillyLazy(this, (AtomicInteger)Preconditions.checkNotNull((Object)value, (Object)"counter"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyLazy && this.equalTo((ImmutableSillyLazy)another);
    }

    private boolean equalTo(ImmutableSillyLazy another) {
        return this.counter.equals(another.counter);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.counter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyLazy").add("counter", (Object)this.counter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int val1() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSillyLazy immutableSillyLazy = this;
            synchronized (immutableSillyLazy) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.val1 = super.val1();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.val1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int val2() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableSillyLazy immutableSillyLazy = this;
            synchronized (immutableSillyLazy) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.val2 = super.val2();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.val2;
    }

    public static ImmutableSillyLazy of(AtomicInteger counter) {
        return new ImmutableSillyLazy(counter);
    }

    public static ImmutableSillyLazy copyOf(SillyLazy instance) {
        if (instance instanceof ImmutableSillyLazy) {
            return (ImmutableSillyLazy)instance;
        }
        return ImmutableSillyLazy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COUNTER = 1L;
        private long initBits = 1L;
        @Nullable
        private AtomicInteger counter;

        private Builder() {
        }

        public final Builder from(SillyLazy instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.counter(instance.counter());
            return this;
        }

        public final Builder counter(AtomicInteger counter) {
            this.counter = (AtomicInteger)Preconditions.checkNotNull((Object)counter, (Object)"counter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSillyLazy build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSillyLazy(null, this.counter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("counter");
            }
            return "Cannot build SillyLazy, some of required attributes are not set " + attributes;
        }
    }
}

