/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyAbstract;
import org.immutables.fixture.SillyPolyHost2;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyPolyHost2
extends SillyPolyHost2 {
    private final SillyAbstract s;
    private final Optional<SillyAbstract> o;

    private ImmutableSillyPolyHost2(SillyAbstract s, Optional<SillyAbstract> o) {
        this.s = s;
        this.o = o;
    }

    @Override
    public SillyAbstract s() {
        return this.s;
    }

    @Override
    public Optional<SillyAbstract> o() {
        return this.o;
    }

    public final ImmutableSillyPolyHost2 withS(SillyAbstract value) {
        if (this.s == value) {
            return this;
        }
        return new ImmutableSillyPolyHost2((SillyAbstract)Preconditions.checkNotNull((Object)value, (Object)"s"), this.o);
    }

    public final ImmutableSillyPolyHost2 withO(SillyAbstract value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableSillyPolyHost2(this.s, (Optional<SillyAbstract>)newValue);
    }

    public final ImmutableSillyPolyHost2 withO(Optional<SillyAbstract> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"o");
        if (this.o == value) {
            return this;
        }
        return new ImmutableSillyPolyHost2(this.s, (Optional<SillyAbstract>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyPolyHost2 && this.equalTo((ImmutableSillyPolyHost2)another);
    }

    private boolean equalTo(ImmutableSillyPolyHost2 another) {
        return this.s.equals(another.s) && this.o.equals(another.o);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.s.hashCode();
        h = h * 17 + this.o.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyPolyHost2").add("s", (Object)this.s).add("o", this.o).toString();
    }

    public static ImmutableSillyPolyHost2 copyOf(SillyPolyHost2 instance) {
        if (instance instanceof ImmutableSillyPolyHost2) {
            return (ImmutableSillyPolyHost2)instance;
        }
        return ImmutableSillyPolyHost2.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_S = 1L;
        private long initBits = 1L;
        @Nullable
        private SillyAbstract s;
        private Optional<SillyAbstract> o = Optional.absent();

        private Builder() {
        }

        public final Builder from(SillyPolyHost2 instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.s(instance.s());
            Optional<SillyAbstract> oOptional = instance.o();
            if (oOptional.isPresent()) {
                this.o(oOptional);
            }
            return this;
        }

        public final Builder s(SillyAbstract s) {
            this.s = (SillyAbstract)Preconditions.checkNotNull((Object)s, (Object)"s");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder o(SillyAbstract o) {
            this.o = Optional.of((Object)o);
            return this;
        }

        public final Builder o(Optional<SillyAbstract> o) {
            this.o = (Optional)Preconditions.checkNotNull(o, (Object)"o");
            return this;
        }

        public ImmutableSillyPolyHost2 build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSillyPolyHost2(this.s, this.o);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("s");
            }
            return "Cannot build SillyPolyHost2, some of required attributes are not set " + attributes;
        }
    }
}

