/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Floats;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.SillyTuplie;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyTuplie
extends SillyTuplie {
    private final float float1;
    private final Optional<Byte> opt2;
    private final ImmutableSet<Boolean> set3;

    private ImmutableSillyTuplie(float float1, Optional<Byte> opt2, Iterable<Boolean> set3) {
        this.float1 = float1;
        this.opt2 = (Optional)Preconditions.checkNotNull(opt2, (Object)"opt2");
        this.set3 = ImmutableSet.copyOf(set3);
    }

    private ImmutableSillyTuplie(ImmutableSillyTuplie original, float float1, Optional<Byte> opt2, ImmutableSet<Boolean> set3) {
        this.float1 = float1;
        this.opt2 = opt2;
        this.set3 = set3;
    }

    @Override
    public float float1() {
        return this.float1;
    }

    @Override
    public Optional<Byte> opt2() {
        return this.opt2;
    }

    public ImmutableSet<Boolean> set3() {
        return this.set3;
    }

    public final ImmutableSillyTuplie withFloat1(float value) {
        if (Float.floatToIntBits(this.float1) == Float.floatToIntBits(value)) {
            return this;
        }
        return new ImmutableSillyTuplie(this, value, this.opt2, this.set3);
    }

    public final ImmutableSillyTuplie withOpt2(byte value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableSillyTuplie(this, this.float1, (Optional<Byte>)newValue, this.set3);
    }

    public final ImmutableSillyTuplie withOpt2(Optional<Byte> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"opt2");
        if (this.opt2 == value) {
            return this;
        }
        return new ImmutableSillyTuplie(this, this.float1, (Optional<Byte>)value, this.set3);
    }

    public final ImmutableSillyTuplie withSet3(boolean ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Booleans.asList((boolean[])elements));
        return new ImmutableSillyTuplie(this, this.float1, this.opt2, (ImmutableSet<Boolean>)newValue);
    }

    public final ImmutableSillyTuplie withSet3(Iterable<Boolean> elements) {
        if (this.set3 == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableSillyTuplie(this, this.float1, this.opt2, (ImmutableSet<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyTuplie && this.equalTo((ImmutableSillyTuplie)another);
    }

    private boolean equalTo(ImmutableSillyTuplie another) {
        return Float.floatToIntBits(this.float1) == Float.floatToIntBits(another.float1) && this.opt2.equals(another.opt2) && this.set3.equals(another.set3);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Floats.hashCode((float)this.float1);
        h = h * 17 + this.opt2.hashCode();
        h = h * 17 + this.set3.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyTuplie").add("float1", this.float1).add("opt2", this.opt2).add("set3", this.set3).toString();
    }

    public static ImmutableSillyTuplie of(float float1, Optional<Byte> opt2, Set<Boolean> set3) {
        return ImmutableSillyTuplie.of(float1, opt2, set3);
    }

    public static ImmutableSillyTuplie of(float float1, Optional<Byte> opt2, Iterable<Boolean> set3) {
        return new ImmutableSillyTuplie(float1, opt2, set3);
    }

    public static ImmutableSillyTuplie copyOf(SillyTuplie instance) {
        if (instance instanceof ImmutableSillyTuplie) {
            return (ImmutableSillyTuplie)instance;
        }
        return ImmutableSillyTuplie.of(instance.float1(), instance.opt2(), instance.set3());
    }
}

