/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.Sing1;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableSing1
implements Sing1 {
    private final ImmutableList<Integer> list;
    private static final ImmutableSing1 INSTANCE = ImmutableSing1.validate(new ImmutableSing1());

    private ImmutableSing1() {
        this.list = ImmutableList.of();
    }

    private ImmutableSing1(ImmutableList<Integer> list) {
        this.list = list;
    }

    public ImmutableList<Integer> list() {
        return this.list;
    }

    public final ImmutableSing1 withList(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return ImmutableSing1.validate(new ImmutableSing1((ImmutableList<Integer>)newValue));
    }

    public final ImmutableSing1 withList(Iterable<Integer> elements) {
        if (this.list == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableSing1.validate(new ImmutableSing1((ImmutableList<Integer>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSing1 && this.equalTo((ImmutableSing1)another);
    }

    private boolean equalTo(ImmutableSing1 another) {
        return this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.list.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Sing1").add("list", this.list).toString();
    }

    public static ImmutableSing1 of() {
        return INSTANCE;
    }

    private static ImmutableSing1 validate(ImmutableSing1 instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableSing1 copyOf(Sing1 instance) {
        if (instance instanceof ImmutableSing1) {
            return (ImmutableSing1)instance;
        }
        return ImmutableSing1.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private ImmutableList.Builder<Integer> listBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(Sing1 instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllList(instance.list());
            return this;
        }

        public final Builder addList(int element) {
            this.listBuilder.add((Object)element);
            return this;
        }

        public final Builder addList(int ... elements) {
            this.listBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder list(Iterable<Integer> elements) {
            this.listBuilder = ImmutableList.builder();
            return this.addAllList(elements);
        }

        public final Builder addAllList(Iterable<Integer> elements) {
            this.listBuilder.addAll(elements);
            return this;
        }

        public ImmutableSing1 build() throws IllegalStateException {
            return ImmutableSing1.validate(new ImmutableSing1(this.listBuilder.build()));
        }
    }
}

