/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.InheritedInterface;
import org.immutables.fixture.SourceOrderingEntity;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSourceOrderingEntity
extends SourceOrderingEntity {
    private final int z;
    private final int y;
    private final int b;
    private final int a;

    private ImmutableSourceOrderingEntity(int z, int y, int b, int a) {
        this.z = z;
        this.y = y;
        this.b = b;
        this.a = a;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int b() {
        return this.b;
    }

    @Override
    public int a() {
        return this.a;
    }

    public final ImmutableSourceOrderingEntity withZ(int value) {
        if (this.z == value) {
            return this;
        }
        return new ImmutableSourceOrderingEntity(value, this.y, this.b, this.a);
    }

    public final ImmutableSourceOrderingEntity withY(int value) {
        if (this.y == value) {
            return this;
        }
        return new ImmutableSourceOrderingEntity(this.z, value, this.b, this.a);
    }

    public final ImmutableSourceOrderingEntity withB(int value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableSourceOrderingEntity(this.z, this.y, value, this.a);
    }

    public final ImmutableSourceOrderingEntity withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableSourceOrderingEntity(this.z, this.y, this.b, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSourceOrderingEntity && this.equalTo((ImmutableSourceOrderingEntity)another);
    }

    private boolean equalTo(ImmutableSourceOrderingEntity another) {
        return this.z == another.z && this.y == another.y && this.b == another.b && this.a == another.a;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.z;
        h = h * 17 + this.y;
        h = h * 17 + this.b;
        h = h * 17 + this.a;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SourceOrderingEntity").add("z", this.z).add("y", this.y).add("b", this.b).add("a", this.a).toString();
    }

    public static ImmutableSourceOrderingEntity copyOf(SourceOrderingEntity instance) {
        if (instance instanceof ImmutableSourceOrderingEntity) {
            return (ImmutableSourceOrderingEntity)instance;
        }
        return ImmutableSourceOrderingEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_Z = 1L;
        private static final long INIT_BIT_Y = 2L;
        private static final long INIT_BIT_B = 4L;
        private static final long INIT_BIT_A = 8L;
        private long initBits = 15L;
        private int z;
        private int y;
        private int b;
        private int a;

        private Builder() {
        }

        public final Builder from(InheritedInterface instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceOrderingEntity instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InheritedInterface instance;
            if (object instanceof InheritedInterface) {
                instance = (InheritedInterface)object;
                this.a(instance.a());
                this.b(instance.b());
            }
            if (object instanceof SourceOrderingEntity) {
                instance = (SourceOrderingEntity)object;
                this.y(((SourceOrderingEntity)instance).y());
                this.z(((SourceOrderingEntity)instance).z());
            }
        }

        public final Builder z(int z) {
            this.z = z;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder y(int y) {
            this.y = y;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder b(int b) {
            this.b = b;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSourceOrderingEntity build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSourceOrderingEntity(this.z, this.y, this.b, this.a);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("z");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("y");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build SourceOrderingEntity, some of required attributes are not set " + attributes;
        }
    }
}

