/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.GenericInheritence;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSub1
implements GenericInheritence.Sub1 {
    private final String a;
    private final Integer b;

    private ImmutableSub1(String a, Integer b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public String a() {
        return this.a;
    }

    @Override
    public Integer b() {
        return this.b;
    }

    public final ImmutableSub1 withA(String value) {
        if (this.a.equals(value)) {
            return this;
        }
        return new ImmutableSub1((String)Preconditions.checkNotNull((Object)value, (Object)"a"), this.b);
    }

    public final ImmutableSub1 withB(Integer value) {
        if (this.b.equals(value)) {
            return this;
        }
        return new ImmutableSub1(this.a, (Integer)Preconditions.checkNotNull((Object)value, (Object)"b"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSub1 && this.equalTo((ImmutableSub1)another);
    }

    private boolean equalTo(ImmutableSub1 another) {
        return this.a.equals(another.a) && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a.hashCode();
        h = h * 17 + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Sub1").add("a", (Object)this.a).add("b", (Object)this.b).toString();
    }

    public static ImmutableSub1 copyOf(GenericInheritence.Sub1 instance) {
        if (instance instanceof ImmutableSub1) {
            return (ImmutableSub1)instance;
        }
        return ImmutableSub1.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        @Nullable
        private String a;
        @Nullable
        private Integer b;

        private Builder() {
        }

        public final Builder from(GenericInheritence.Sub1 instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a((String)instance.a());
            this.b((Integer)instance.b());
            return this;
        }

        public final Builder a(String a) {
            this.a = (String)Preconditions.checkNotNull((Object)a, (Object)"a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder b(Integer b) {
            this.b = (Integer)Preconditions.checkNotNull((Object)b, (Object)"b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSub1 build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSub1(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build Sub1, some of required attributes are not set " + attributes;
        }
    }
}

