/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.GenericInheritence;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSub2
implements GenericInheritence.Sub2 {
    private final Long a;
    private final Double b;

    private ImmutableSub2(Long a, Double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public Long a() {
        return this.a;
    }

    @Override
    public Double b() {
        return this.b;
    }

    public final ImmutableSub2 withA(Long value) {
        if (this.a.equals(value)) {
            return this;
        }
        return new ImmutableSub2((Long)Preconditions.checkNotNull((Object)value, (Object)"a"), this.b);
    }

    public final ImmutableSub2 withB(Double value) {
        if (this.b.equals(value)) {
            return this;
        }
        return new ImmutableSub2(this.a, (Double)Preconditions.checkNotNull((Object)value, (Object)"b"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSub2 && this.equalTo((ImmutableSub2)another);
    }

    private boolean equalTo(ImmutableSub2 another) {
        return this.a.equals(another.a) && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a.hashCode();
        h = h * 17 + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Sub2").add("a", (Object)this.a).add("b", (Object)this.b).toString();
    }

    public static ImmutableSub2 copyOf(GenericInheritence.Sub2 instance) {
        if (instance instanceof ImmutableSub2) {
            return (ImmutableSub2)instance;
        }
        return ImmutableSub2.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        @Nullable
        private Long a;
        @Nullable
        private Double b;

        private Builder() {
        }

        public final Builder from(GenericInheritence.Sub2 instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a((Long)instance.a());
            this.b((Double)instance.b());
            return this;
        }

        public final Builder a(Long a) {
            this.a = (Long)Preconditions.checkNotNull((Object)a, (Object)"a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder b(Double b) {
            this.b = (Double)Preconditions.checkNotNull((Object)b, (Object)"b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSub2 build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSub2(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build Sub2, some of required attributes are not set " + attributes;
        }
    }
}

