/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.UseImmutableCollections;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableUseImmutableCollections
implements UseImmutableCollections {
    private final ImmutableList<String> list;
    private final ImmutableSet<Integer> set;
    private final ImmutableSet<RetentionPolicy> enumSet;
    private final ImmutableSortedSet<RetentionPolicy> sortedSet;
    private final ImmutableMultiset<String> multiset;
    private final ImmutableMap<String, Integer> map;
    private final ImmutableMap<RetentionPolicy, Integer> enumMap;
    private final ImmutableSortedMap<RetentionPolicy, Integer> sortedMap;
    private final ImmutableMultimap<String, Integer> multimap;
    private final ImmutableSetMultimap<String, Integer> setMultimap;
    private final ImmutableListMultimap<String, Integer> listMultimap;

    private ImmutableUseImmutableCollections(ImmutableList<String> list, ImmutableSet<Integer> set, ImmutableSet<RetentionPolicy> enumSet, ImmutableSortedSet<RetentionPolicy> sortedSet, ImmutableMultiset<String> multiset, ImmutableMap<String, Integer> map, ImmutableMap<RetentionPolicy, Integer> enumMap, ImmutableSortedMap<RetentionPolicy, Integer> sortedMap, ImmutableMultimap<String, Integer> multimap, ImmutableSetMultimap<String, Integer> setMultimap, ImmutableListMultimap<String, Integer> listMultimap) {
        this.list = list;
        this.set = set;
        this.enumSet = enumSet;
        this.sortedSet = sortedSet;
        this.multiset = multiset;
        this.map = map;
        this.enumMap = enumMap;
        this.sortedMap = sortedMap;
        this.multimap = multimap;
        this.setMultimap = setMultimap;
        this.listMultimap = listMultimap;
    }

    @Override
    public ImmutableList<String> list() {
        return this.list;
    }

    @Override
    public ImmutableSet<Integer> set() {
        return this.set;
    }

    @Override
    public ImmutableSet<RetentionPolicy> enumSet() {
        return this.enumSet;
    }

    @Override
    public ImmutableSortedSet<RetentionPolicy> sortedSet() {
        return this.sortedSet;
    }

    @Override
    public ImmutableMultiset<String> multiset() {
        return this.multiset;
    }

    @Override
    public ImmutableMap<String, Integer> map() {
        return this.map;
    }

    @Override
    public ImmutableMap<RetentionPolicy, Integer> enumMap() {
        return this.enumMap;
    }

    @Override
    public ImmutableSortedMap<RetentionPolicy, Integer> sortedMap() {
        return this.sortedMap;
    }

    @Override
    public ImmutableMultimap<String, Integer> multimap() {
        return this.multimap;
    }

    @Override
    public ImmutableSetMultimap<String, Integer> setMultimap() {
        return this.setMultimap;
    }

    @Override
    public ImmutableListMultimap<String, Integer> listMultimap() {
        return this.listMultimap;
    }

    public final ImmutableUseImmutableCollections withList(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUseImmutableCollections((ImmutableList<String>)newValue, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withList(Iterable<String> elements) {
        if (this.list == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUseImmutableCollections((ImmutableList<String>)newValue, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSet(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableUseImmutableCollections(this.list, (ImmutableSet<Integer>)newValue, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSet(Iterable<Integer> elements) {
        if (this.set == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableUseImmutableCollections(this.list, (ImmutableSet<Integer>)newValue, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withEnumSet(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableUseImmutableCollections(this.list, this.set, (ImmutableSet<RetentionPolicy>)newValue, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withEnumSet(Iterable<RetentionPolicy> elements) {
        if (this.enumSet == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, (ImmutableSet<RetentionPolicy>)newValue, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSortedSet(RetentionPolicy ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), Arrays.asList(elements));
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, (ImmutableSortedSet<RetentionPolicy>)newValue, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSortedSet(Iterable<? extends RetentionPolicy> elements) {
        if (this.sortedSet == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, (ImmutableSortedSet<RetentionPolicy>)newValue, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMultiset(String ... elements) {
        ImmutableMultiset newValue = ImmutableMultiset.copyOf((Object[])elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, (ImmutableMultiset<String>)newValue, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMultiset(Iterable<String> elements) {
        if (this.multiset == elements) {
            return this;
        }
        ImmutableMultiset newValue = ImmutableMultiset.copyOf(elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, (ImmutableMultiset<String>)newValue, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMap(Map<String, ? extends Integer> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, (ImmutableMap<String, Integer>)value, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withEnumMap(Map<RetentionPolicy, ? extends Integer> entries) {
        if (this.enumMap == entries) {
            return this;
        }
        ImmutableMap value = Maps.immutableEnumMap(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, (ImmutableMap<RetentionPolicy, Integer>)value, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
        if (this.sortedMap == entries) {
            return this;
        }
        ImmutableSortedMap value = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural().reverse());
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, (ImmutableSortedMap<RetentionPolicy, Integer>)value, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMultimap(Multimap<String, ? extends Integer> entries) {
        if (this.multimap == entries) {
            return this;
        }
        ImmutableMultimap value = ImmutableMultimap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, (ImmutableMultimap<String, Integer>)value, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSetMultimap(Multimap<String, ? extends Integer> entries) {
        if (this.setMultimap == entries) {
            return this;
        }
        ImmutableSetMultimap value = ImmutableSetMultimap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, (ImmutableSetMultimap<String, Integer>)value, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withListMultimap(Multimap<String, ? extends Integer> entries) {
        if (this.listMultimap == entries) {
            return this;
        }
        ImmutableListMultimap value = ImmutableListMultimap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, (ImmutableListMultimap<String, Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUseImmutableCollections && this.equalTo((ImmutableUseImmutableCollections)another);
    }

    private boolean equalTo(ImmutableUseImmutableCollections another) {
        return this.list.equals(another.list) && this.set.equals(another.set) && this.enumSet.equals(another.enumSet) && this.sortedSet.equals(another.sortedSet) && this.multiset.equals(another.multiset) && this.map.equals(another.map) && this.enumMap.equals(another.enumMap) && this.sortedMap.equals(another.sortedMap) && this.multimap.equals(another.multimap) && this.setMultimap.equals(another.setMultimap) && this.listMultimap.equals(another.listMultimap);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.list.hashCode();
        h = h * 17 + this.set.hashCode();
        h = h * 17 + this.enumSet.hashCode();
        h = h * 17 + this.sortedSet.hashCode();
        h = h * 17 + this.multiset.hashCode();
        h = h * 17 + this.map.hashCode();
        h = h * 17 + this.enumMap.hashCode();
        h = h * 17 + this.sortedMap.hashCode();
        h = h * 17 + this.multimap.hashCode();
        h = h * 17 + this.setMultimap.hashCode();
        h = h * 17 + this.listMultimap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UseImmutableCollections").add("list", this.list).add("set", this.set).add("enumSet", this.enumSet).add("sortedSet", this.sortedSet).add("multiset", this.multiset).add("map", this.map).add("enumMap", this.enumMap).add("sortedMap", this.sortedMap).add("multimap", this.multimap).add("setMultimap", this.setMultimap).add("listMultimap", this.listMultimap).toString();
    }

    public static ImmutableUseImmutableCollections copyOf(UseImmutableCollections instance) {
        if (instance instanceof ImmutableUseImmutableCollections) {
            return (ImmutableUseImmutableCollections)instance;
        }
        return ImmutableUseImmutableCollections.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> listBuilder = ImmutableList.builder();
        private ImmutableSet.Builder<Integer> setBuilder = ImmutableSet.builder();
        private ImmutableSet.Builder<RetentionPolicy> enumSetBuilder = ImmutableSet.builder();
        private ImmutableSortedSet.Builder<RetentionPolicy> sortedSetBuilder = ImmutableSortedSet.naturalOrder();
        private ImmutableMultiset.Builder<String> multisetBuilder = ImmutableMultiset.builder();
        private ImmutableMap.Builder<String, Integer> mapBuilder = ImmutableMap.builder();
        private ImmutableMap.Builder<RetentionPolicy, Integer> enumMapBuilder = ImmutableMap.builder();
        private ImmutableSortedMap.Builder<RetentionPolicy, Integer> sortedMapBuilder = ImmutableSortedMap.reverseOrder();
        private ImmutableMultimap.Builder<String, Integer> multimapBuilder = ImmutableMultimap.builder();
        private ImmutableSetMultimap.Builder<String, Integer> setMultimapBuilder = ImmutableSetMultimap.builder();
        private ImmutableListMultimap.Builder<String, Integer> listMultimapBuilder = ImmutableListMultimap.builder();

        private Builder() {
        }

        public final Builder from(UseImmutableCollections instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllList((Iterable<String>)instance.list());
            this.addAllSet((Iterable<Integer>)instance.set());
            this.addAllEnumSet((Iterable<RetentionPolicy>)instance.enumSet());
            this.addAllSortedSet((Iterable<? extends RetentionPolicy>)instance.sortedSet());
            this.addAllMultiset((Iterable<String>)instance.multiset());
            this.putAllMap((Map<String, ? extends Integer>)instance.map());
            this.putAllEnumMap((Map<RetentionPolicy, ? extends Integer>)instance.enumMap());
            this.putAllSortedMap((Map<? extends RetentionPolicy, ? extends Integer>)instance.sortedMap());
            this.putAllMultimap((Multimap<String, ? extends Integer>)instance.multimap());
            this.putAllSetMultimap((Multimap<String, ? extends Integer>)instance.setMultimap());
            this.putAllListMultimap((Multimap<String, ? extends Integer>)instance.listMultimap());
            return this;
        }

        public final Builder addList(String element) {
            this.listBuilder.add((Object)element);
            return this;
        }

        public final Builder addList(String ... elements) {
            this.listBuilder.add((Object[])elements);
            return this;
        }

        public final Builder list(Iterable<String> elements) {
            this.listBuilder = ImmutableList.builder();
            return this.addAllList(elements);
        }

        public final Builder addAllList(Iterable<String> elements) {
            this.listBuilder.addAll(elements);
            return this;
        }

        public final Builder addSet(int element) {
            this.setBuilder.add((Object)element);
            return this;
        }

        public final Builder addSet(int ... elements) {
            this.setBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder set(Iterable<Integer> elements) {
            this.setBuilder = ImmutableSet.builder();
            return this.addAllSet(elements);
        }

        public final Builder addAllSet(Iterable<Integer> elements) {
            this.setBuilder.addAll(elements);
            return this;
        }

        public final Builder addEnumSet(RetentionPolicy element) {
            this.enumSetBuilder.add((Object)element);
            return this;
        }

        public final Builder addEnumSet(RetentionPolicy ... elements) {
            this.enumSetBuilder.addAll(Arrays.asList(elements));
            return this;
        }

        public final Builder enumSet(Iterable<RetentionPolicy> elements) {
            this.enumSetBuilder = ImmutableSet.builder();
            return this.addAllEnumSet(elements);
        }

        public final Builder addAllEnumSet(Iterable<RetentionPolicy> elements) {
            this.enumSetBuilder.addAll(elements);
            return this;
        }

        public final Builder addSortedSet(RetentionPolicy element) {
            this.sortedSetBuilder.add((Object)element);
            return this;
        }

        public final Builder addSortedSet(RetentionPolicy ... elements) {
            this.sortedSetBuilder.addAll(Arrays.asList(elements));
            return this;
        }

        public final Builder sortedSet(Iterable<? extends RetentionPolicy> elements) {
            this.sortedSetBuilder = ImmutableSortedSet.naturalOrder();
            return this.addAllSortedSet(elements);
        }

        public final Builder addAllSortedSet(Iterable<? extends RetentionPolicy> elements) {
            this.sortedSetBuilder.addAll(elements);
            return this;
        }

        public final Builder addMultiset(String element) {
            this.multisetBuilder.add((Object)element);
            return this;
        }

        public final Builder addMultiset(String ... elements) {
            this.multisetBuilder.add((Object[])elements);
            return this;
        }

        public final Builder multiset(Iterable<String> elements) {
            this.multisetBuilder = ImmutableMultiset.builder();
            return this.addAllMultiset(elements);
        }

        public final Builder addAllMultiset(Iterable<String> elements) {
            this.multisetBuilder.addAll(elements);
            return this;
        }

        public final Builder putMap(String key, int value) {
            this.mapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMap(Map.Entry<String, ? extends Integer> entry) {
            this.mapBuilder.put(entry);
            return this;
        }

        public final Builder map(Map<String, ? extends Integer> entries) {
            this.mapBuilder = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        public final Builder putAllMap(Map<String, ? extends Integer> entries) {
            this.mapBuilder.putAll(entries);
            return this;
        }

        public final Builder putEnumMap(RetentionPolicy key, int value) {
            this.enumMapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putEnumMap(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
            this.enumMapBuilder.put(entry);
            return this;
        }

        public final Builder enumMap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.enumMapBuilder = ImmutableMap.builder();
            return this.putAllEnumMap(entries);
        }

        public final Builder putAllEnumMap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.enumMapBuilder.putAll(entries);
            return this;
        }

        public final Builder putSortedMap(RetentionPolicy key, int value) {
            this.sortedMapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putSortedMap(Map.Entry<? extends RetentionPolicy, ? extends Integer> entry) {
            this.sortedMapBuilder.put(entry);
            return this;
        }

        public final Builder sortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
            this.sortedMapBuilder = ImmutableSortedMap.reverseOrder();
            return this.putAllSortedMap(entries);
        }

        public final Builder putAllSortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
            this.sortedMapBuilder.putAll(entries);
            return this;
        }

        public final Builder putMultimap(String key, int ... values) {
            this.multimapBuilder.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        public final Builder putAllMultimap(String key, Iterable<Integer> values) {
            this.multimapBuilder.putAll((Object)key, values);
            return this;
        }

        public final Builder putMultimap(String key, int value) {
            this.multimapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMultimap(Map.Entry<String, ? extends Integer> entry) {
            this.multimapBuilder.put(entry);
            return this;
        }

        public final Builder multimap(Multimap<String, ? extends Integer> entries) {
            this.multimapBuilder = ImmutableMultimap.builder();
            return this.putAllMultimap(entries);
        }

        public final Builder putAllMultimap(Multimap<String, ? extends Integer> entries) {
            this.multimapBuilder.putAll(entries);
            return this;
        }

        public final Builder putSetMultimap(String key, int ... values) {
            this.setMultimapBuilder.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        public final Builder putAllSetMultimap(String key, Iterable<Integer> values) {
            this.setMultimapBuilder.putAll((Object)key, values);
            return this;
        }

        public final Builder putSetMultimap(String key, int value) {
            this.setMultimapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putSetMultimap(Map.Entry<String, ? extends Integer> entry) {
            this.setMultimapBuilder.put(entry);
            return this;
        }

        public final Builder setMultimap(Multimap<String, ? extends Integer> entries) {
            this.setMultimapBuilder = ImmutableSetMultimap.builder();
            return this.putAllSetMultimap(entries);
        }

        public final Builder putAllSetMultimap(Multimap<String, ? extends Integer> entries) {
            this.setMultimapBuilder.putAll(entries);
            return this;
        }

        public final Builder putListMultimap(String key, int ... values) {
            this.listMultimapBuilder.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        public final Builder putAllListMultimap(String key, Iterable<Integer> values) {
            this.listMultimapBuilder.putAll((Object)key, values);
            return this;
        }

        public final Builder putListMultimap(String key, int value) {
            this.listMultimapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putListMultimap(Map.Entry<String, ? extends Integer> entry) {
            this.listMultimapBuilder.put(entry);
            return this;
        }

        public final Builder listMultimap(Multimap<String, ? extends Integer> entries) {
            this.listMultimapBuilder = ImmutableListMultimap.builder();
            return this.putAllListMultimap(entries);
        }

        public final Builder putAllListMultimap(Multimap<String, ? extends Integer> entries) {
            this.listMultimapBuilder.putAll(entries);
            return this;
        }

        public ImmutableUseImmutableCollections build() throws IllegalStateException {
            return new ImmutableUseImmutableCollections(this.listBuilder.build(), this.setBuilder.build(), Sets.immutableEnumSet((Iterable)this.enumSetBuilder.build()), this.sortedSetBuilder.build(), this.multisetBuilder.build(), this.mapBuilder.build(), Maps.immutableEnumMap((Map)this.enumMapBuilder.build()), this.sortedMapBuilder.build(), this.multimapBuilder.build(), this.setMultimapBuilder.build(), this.listMultimapBuilder.build());
        }
    }
}

