/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ValDerivedCollection;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableValDerivedCollection
extends ValDerivedCollection {
    private final Set<Integer> available = (Set)Preconditions.checkNotNull(super.available(), (Object)"available");

    private ImmutableValDerivedCollection(Builder builder) {
    }

    @Override
    Set<Integer> available() {
        return this.available;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValDerivedCollection && this.equalTo((ImmutableValDerivedCollection)another);
    }

    private boolean equalTo(ImmutableValDerivedCollection another) {
        return this.available.equals(another.available);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.available.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValDerivedCollection").add("available", this.available).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private Builder() {
        }

        public final Builder from(ValDerivedCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            return this;
        }

        public ImmutableValDerivedCollection build() throws IllegalStateException {
            return new ImmutableValDerivedCollection(this);
        }
    }
}

