/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.Wildcards;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableWildcards
implements Wildcards {
    private final List<?> wilcards;
    private final Optional<? super String> optional;

    private ImmutableWildcards(List<?> wilcards, Optional<? super String> optional) {
        this.wilcards = wilcards;
        this.optional = optional;
    }

    @Override
    public List<?> wilcards() {
        return this.wilcards;
    }

    @Override
    public Optional<? super String> optional() {
        return this.optional;
    }

    public final ImmutableWildcards withWilcards(List<?> value) {
        if (this.wilcards == value) {
            return this;
        }
        return new ImmutableWildcards((List)Preconditions.checkNotNull(value, (Object)"wilcards"), this.optional);
    }

    public final ImmutableWildcards withOptional(Optional<? super String> value) {
        if (this.optional == value) {
            return this;
        }
        return new ImmutableWildcards(this.wilcards, (Optional<? super String>)((Optional)Preconditions.checkNotNull(value, (Object)"optional")));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWildcards && this.equalTo((ImmutableWildcards)another);
    }

    private boolean equalTo(ImmutableWildcards another) {
        return this.wilcards.equals(another.wilcards) && this.optional.equals(another.optional);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.wilcards.hashCode();
        h = h * 17 + this.optional.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Wildcards").add("wilcards", this.wilcards).add("optional", this.optional).toString();
    }

    public static ImmutableWildcards copyOf(Wildcards instance) {
        if (instance instanceof ImmutableWildcards) {
            return (ImmutableWildcards)instance;
        }
        return ImmutableWildcards.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WILCARDS = 1L;
        private static final long INIT_BIT_OPTIONAL = 2L;
        private long initBits = 3L;
        @Nullable
        private List<?> wilcards;
        @Nullable
        private Optional<? super String> optional;

        private Builder() {
        }

        public final Builder from(Wildcards instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.wilcards(instance.wilcards());
            this.optional(instance.optional());
            return this;
        }

        public final Builder wilcards(List<?> wilcards) {
            this.wilcards = (List)Preconditions.checkNotNull(wilcards, (Object)"wilcards");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder optional(Optional<? super String> optional) {
            this.optional = (Optional)Preconditions.checkNotNull(optional, (Object)"optional");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWildcards build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWildcards(this.wilcards, this.optional);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wilcards");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("optional");
            }
            return "Cannot build Wildcards, some of required attributes are not set " + attributes;
        }
    }
}

