/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.atlassian.fugue.Option;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.fixture.SillyStructureWithId;
import org.immutables.fixture.SillyTuplie;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.gson.adapter.FieldNamingTranslator;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class SillyStructureWithIdRepository
extends Repositories.Repository<SillyStructureWithId> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillyStructureWithId";
    private final Serialization serialization = new Serialization(this.getGson());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public SillyStructureWithIdRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, SillyStructureWithId.class);
    }

    public FluentFuture<Integer> insert(SillyStructureWithId document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillyStructureWithId> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder findById(String id) {
        return this.find(this.criteria().id(id));
    }

    public FluentFuture<Integer> upsert(SillyStructureWithId document) {
        Criteria byId = this.criteria().id(document.id());
        return super.doUpsert((Constraints.ConstraintHost)byId.constraint, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    private static class Serialization {
        private static final TypeToken<SillySubstructure> SUBS6_TYPE_TOKEN = TypeToken.get(SillySubstructure.class);
        private static final TypeToken<SillySubstructure> NEST7_TYPE_TOKEN = TypeToken.get(SillySubstructure.class);
        private static final TypeToken<SillyTuplie> TUP3_TYPE_TOKEN = TypeToken.get(SillyTuplie.class);
        final TypeAdapter<SillySubstructure> subs6TypeAdapter;
        final TypeAdapter<SillySubstructure> nest7TypeAdapter;
        final TypeAdapter<SillyTuplie> tup3TypeAdapter;
        final Gson gson;
        final String idName;
        final String attr1Name;
        final String flag2Name;
        final String opt3Name;
        final String opt4Name;
        final String opt5Name;
        final String very4Name;
        final String wet5Name;
        final String subs6Name;
        final String nest7Name;
        final String tup3Name;
        final String int9Name;

        Serialization(Gson gson) {
            this.gson = gson;
            this.subs6TypeAdapter = gson.getAdapter(SUBS6_TYPE_TOKEN);
            this.nest7TypeAdapter = gson.getAdapter(NEST7_TYPE_TOKEN);
            this.tup3TypeAdapter = gson.getAdapter(TUP3_TYPE_TOKEN);
            FieldNamingTranslator fieldNaming = new FieldNamingTranslator(gson);
            this.idName = fieldNaming.translateName(SillyStructureWithId.class, String.class, "id", "_id");
            this.attr1Name = fieldNaming.translateName(SillyStructureWithId.class, String.class, "attr1", "");
            this.flag2Name = fieldNaming.translateName(SillyStructureWithId.class, Boolean.TYPE, "flag2", "");
            this.opt3Name = fieldNaming.translateName(SillyStructureWithId.class, Optional.class, "opt3", "");
            this.opt4Name = fieldNaming.translateName(SillyStructureWithId.class, Option.class, "opt4", "");
            this.opt5Name = fieldNaming.translateName(SillyStructureWithId.class, io.atlassian.fugue.Option.class, "opt5", "");
            this.very4Name = fieldNaming.translateName(SillyStructureWithId.class, Long.TYPE, "very4", "");
            this.wet5Name = fieldNaming.translateName(SillyStructureWithId.class, Double.TYPE, "wet5", "");
            this.subs6Name = fieldNaming.translateName(SillyStructureWithId.class, List.class, "subs6", "");
            this.nest7Name = fieldNaming.translateName(SillyStructureWithId.class, SillySubstructure.class, "nest7", "");
            this.tup3Name = fieldNaming.translateName(SillyStructureWithId.class, Optional.class, "tup3", "");
            this.int9Name = fieldNaming.translateName(SillyStructureWithId.class, Integer.TYPE, "int9", "");
        }
    }

    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria id(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, false, Support.writable((Object)value)));
        }

        public Criteria idNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, true, Support.writable((Object)value)));
        }

        public Criteria idIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, (Iterable)wrappedValues));
        }

        public Criteria idIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, (Iterable)values));
        }

        public Criteria idNotIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, (Iterable)wrappedValues));
        }

        public Criteria idNotIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, (Iterable)values));
        }

        public Criteria idStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria idMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, pattern));
        }

        public Criteria idNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, true, pattern));
        }

        public Criteria idGreaterThan(String lower) {
            return this.idIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria idLessThan(String upper) {
            return this.idIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria idAtMost(String upperInclusive) {
            return this.idIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria idAtLeast(String lowerInclusive) {
            return this.idIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria idIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, false, Support.writable(range)));
        }

        public Criteria idNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, true, Support.writable(range)));
        }

        public Criteria attr1(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.attr1Name, false, Support.writable((Object)value)));
        }

        public Criteria attr1Not(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.attr1Name, true, Support.writable((Object)value)));
        }

        public Criteria attr1In(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, false, (Iterable)wrappedValues));
        }

        public Criteria attr1In(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, false, (Iterable)values));
        }

        public Criteria attr1NotIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, true, (Iterable)wrappedValues));
        }

        public Criteria attr1NotIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, true, (Iterable)values));
        }

        public Criteria attr1StartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.attr1Name, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria attr1Matches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.attr1Name, false, pattern));
        }

        public Criteria attr1NotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.attr1Name, true, pattern));
        }

        public Criteria attr1GreaterThan(String lower) {
            return this.attr1In((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria attr1LessThan(String upper) {
            return this.attr1In((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria attr1AtMost(String upperInclusive) {
            return this.attr1In((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria attr1AtLeast(String lowerInclusive) {
            return this.attr1In((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria attr1In(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.attr1Name, false, Support.writable(range)));
        }

        public Criteria attr1NotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.attr1Name, true, Support.writable(range)));
        }

        public Criteria flag2(boolean value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.flag2Name, false, Support.writable((Object)value)));
        }

        public Criteria opt3(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt3Name, false, Support.writable((Object)value)));
        }

        public Criteria opt3Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt3Name, true, Support.writable((Object)value)));
        }

        public Criteria opt3In(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, false, (Iterable)wrappedValues));
        }

        public Criteria opt3In(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, false, (Iterable)values));
        }

        public Criteria opt3NotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, true, (Iterable)wrappedValues));
        }

        public Criteria opt3NotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, true, (Iterable)values));
        }

        public Criteria opt3Present() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt3Name, true, null));
        }

        public Criteria opt3Absent() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt3Name, false, null));
        }

        public Criteria opt4(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt4Name, false, Support.writable((Object)value)));
        }

        public Criteria opt4Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt4Name, true, Support.writable((Object)value)));
        }

        public Criteria opt4In(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt4Name, false, (Iterable)wrappedValues));
        }

        public Criteria opt4In(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt4Name, false, (Iterable)values));
        }

        public Criteria opt4NotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt4Name, true, (Iterable)wrappedValues));
        }

        public Criteria opt4NotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt4Name, true, (Iterable)values));
        }

        public Criteria opt4Present() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt4Name, true, null));
        }

        public Criteria opt4Absent() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt4Name, false, null));
        }

        public Criteria opt5(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt5Name, false, Support.writable((Object)value)));
        }

        public Criteria opt5Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt5Name, true, Support.writable((Object)value)));
        }

        public Criteria opt5In(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, false, (Iterable)wrappedValues));
        }

        public Criteria opt5In(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, false, (Iterable)values));
        }

        public Criteria opt5NotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, true, (Iterable)wrappedValues));
        }

        public Criteria opt5NotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, true, (Iterable)values));
        }

        public Criteria opt5Present() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt5Name, true, null));
        }

        public Criteria opt5Absent() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt5Name, false, null));
        }

        public Criteria very4(long value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.very4Name, false, Support.writable((Object)value)));
        }

        public Criteria very4Not(long value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.very4Name, true, Support.writable((Object)value)));
        }

        public Criteria very4In(Iterable<Long> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Long value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, false, (Iterable)wrappedValues));
        }

        public Criteria very4In(long first, long second, long ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (long value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, false, (Iterable)values));
        }

        public Criteria very4NotIn(Iterable<Long> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Long value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, true, (Iterable)wrappedValues));
        }

        public Criteria very4NotIn(long first, long second, long ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (long value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, true, (Iterable)values));
        }

        public Criteria very4GreaterThan(long lower) {
            return this.very4In((Range<Long>)Range.greaterThan((Comparable)Long.valueOf(lower)));
        }

        public Criteria very4LessThan(long upper) {
            return this.very4In((Range<Long>)Range.lessThan((Comparable)Long.valueOf(upper)));
        }

        public Criteria very4AtMost(long upperInclusive) {
            return this.very4In((Range<Long>)Range.atMost((Comparable)Long.valueOf(upperInclusive)));
        }

        public Criteria very4AtLeast(long lowerInclusive) {
            return this.very4In((Range<Long>)Range.atLeast((Comparable)Long.valueOf(lowerInclusive)));
        }

        public Criteria very4In(Range<Long> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.very4Name, false, Support.writable(range)));
        }

        public Criteria very4NotIn(Range<Long> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.very4Name, true, Support.writable(range)));
        }

        public Criteria wet5(double value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.wet5Name, false, Support.writable((Object)value)));
        }

        public Criteria wet5Not(double value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.wet5Name, true, Support.writable((Object)value)));
        }

        public Criteria wet5In(Iterable<Double> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Double value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, false, (Iterable)wrappedValues));
        }

        public Criteria wet5In(double first, double second, double ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (double value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, false, (Iterable)values));
        }

        public Criteria wet5NotIn(Iterable<Double> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Double value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, true, (Iterable)wrappedValues));
        }

        public Criteria wet5NotIn(double first, double second, double ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (double value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, true, (Iterable)values));
        }

        public Criteria wet5GreaterThan(double lower) {
            return this.wet5In((Range<Double>)Range.greaterThan((Comparable)Double.valueOf(lower)));
        }

        public Criteria wet5LessThan(double upper) {
            return this.wet5In((Range<Double>)Range.lessThan((Comparable)Double.valueOf(upper)));
        }

        public Criteria wet5AtMost(double upperInclusive) {
            return this.wet5In((Range<Double>)Range.atMost((Comparable)Double.valueOf(upperInclusive)));
        }

        public Criteria wet5AtLeast(double lowerInclusive) {
            return this.wet5In((Range<Double>)Range.atLeast((Comparable)Double.valueOf(lowerInclusive)));
        }

        public Criteria wet5In(Range<Double> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.wet5Name, false, Support.writable(range)));
        }

        public Criteria wet5NotIn(Range<Double> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.wet5Name, true, Support.writable(range)));
        }

        public Criteria subs6Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.subs6Name, false, 0));
        }

        public Criteria subs6NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.subs6Name, true, 0));
        }

        public Criteria subs6Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.subs6Name, false, size));
        }

        public Criteria subs6Contains(SillySubstructure value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6TypeAdapter, (Object)value)));
        }

        public Criteria subs6ContainsAll(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.subs6Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, (Object)wrappedValues)));
        }

        public Criteria nest7(SillySubstructure value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7TypeAdapter, (Object)value)));
        }

        public Criteria nest7Not(SillySubstructure value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.nest7Name, true, Support.writable(this.serialization.nest7TypeAdapter, (Object)value)));
        }

        public Criteria nest7In(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, false, (Iterable)wrappedValues));
        }

        public Criteria nest7In(SillySubstructure first, SillySubstructure second, SillySubstructure ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)first));
            values.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)second));
            for (SillySubstructure value : rest) {
                values.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, false, (Iterable)values));
        }

        public Criteria nest7NotIn(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, true, (Iterable)wrappedValues));
        }

        public Criteria nest7NotIn(SillySubstructure first, SillySubstructure second, SillySubstructure ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)first));
            values.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)second));
            for (SillySubstructure value : rest) {
                values.add(Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, true, (Iterable)values));
        }

        public Criteria tup3(SillyTuplie value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3TypeAdapter, (Object)value)));
        }

        public Criteria tup3Not(SillyTuplie value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.tup3Name, true, Support.writable(this.serialization.tup3TypeAdapter, (Object)value)));
        }

        public Criteria tup3In(Iterable<SillyTuplie> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillyTuplie value : values) {
                wrappedValues.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, false, (Iterable)wrappedValues));
        }

        public Criteria tup3In(SillyTuplie first, SillyTuplie second, SillyTuplie ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)first));
            values.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)second));
            for (SillyTuplie value : rest) {
                values.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, false, (Iterable)values));
        }

        public Criteria tup3NotIn(Iterable<SillyTuplie> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillyTuplie value : values) {
                wrappedValues.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, true, (Iterable)wrappedValues));
        }

        public Criteria tup3NotIn(SillyTuplie first, SillyTuplie second, SillyTuplie ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)first));
            values.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)second));
            for (SillyTuplie value : rest) {
                values.add(Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, true, (Iterable)values));
        }

        public Criteria tup3Present() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.tup3Name, true, null));
        }

        public Criteria tup3Absent() {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.tup3Name, false, null));
        }

        public Criteria int9(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.int9Name, false, Support.writable((Object)value)));
        }

        public Criteria int9Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.int9Name, true, Support.writable((Object)value)));
        }

        public Criteria int9In(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, false, (Iterable)wrappedValues));
        }

        public Criteria int9In(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, false, (Iterable)values));
        }

        public Criteria int9NotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, true, (Iterable)wrappedValues));
        }

        public Criteria int9NotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, true, (Iterable)values));
        }

        public Criteria int9GreaterThan(int lower) {
            return this.int9In((Range<Integer>)Range.greaterThan((Comparable)Integer.valueOf(lower)));
        }

        public Criteria int9LessThan(int upper) {
            return this.int9In((Range<Integer>)Range.lessThan((Comparable)Integer.valueOf(upper)));
        }

        public Criteria int9AtMost(int upperInclusive) {
            return this.int9In((Range<Integer>)Range.atMost((Comparable)Integer.valueOf(upperInclusive)));
        }

        public Criteria int9AtLeast(int lowerInclusive) {
            return this.int9In((Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(lowerInclusive)));
        }

        public Criteria int9In(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.int9Name, false, Support.writable(range)));
        }

        public Criteria int9NotIn(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.int9Name, true, Support.writable(range)));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public String toString() {
            return "SillyStructureWithIdRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillyStructureWithId, Indexer> {
        private final Serialization serialization;

        private Indexer(SillyStructureWithIdRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withId() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Indexer withAttr1() {
            this.fields = this.fields.equal(this.serialization.attr1Name, false, (Object)1);
            return this;
        }

        public Indexer withAttr1Desceding() {
            this.fields = this.fields.equal(this.serialization.attr1Name, false, (Object)-1);
            return this;
        }

        public Indexer withFlag2() {
            this.fields = this.fields.equal(this.serialization.flag2Name, false, (Object)1);
            return this;
        }

        public Indexer withFlag2Desceding() {
            this.fields = this.fields.equal(this.serialization.flag2Name, false, (Object)-1);
            return this;
        }

        public Indexer withOpt3() {
            this.fields = this.fields.equal(this.serialization.opt3Name, false, (Object)1);
            return this;
        }

        public Indexer withOpt3Desceding() {
            this.fields = this.fields.equal(this.serialization.opt3Name, false, (Object)-1);
            return this;
        }

        public Indexer withOpt4() {
            this.fields = this.fields.equal(this.serialization.opt4Name, false, (Object)1);
            return this;
        }

        public Indexer withOpt4Desceding() {
            this.fields = this.fields.equal(this.serialization.opt4Name, false, (Object)-1);
            return this;
        }

        public Indexer withOpt5() {
            this.fields = this.fields.equal(this.serialization.opt5Name, false, (Object)1);
            return this;
        }

        public Indexer withOpt5Desceding() {
            this.fields = this.fields.equal(this.serialization.opt5Name, false, (Object)-1);
            return this;
        }

        public Indexer withVery4() {
            this.fields = this.fields.equal(this.serialization.very4Name, false, (Object)1);
            return this;
        }

        public Indexer withVery4Desceding() {
            this.fields = this.fields.equal(this.serialization.very4Name, false, (Object)-1);
            return this;
        }

        public Indexer withWet5() {
            this.fields = this.fields.equal(this.serialization.wet5Name, false, (Object)1);
            return this;
        }

        public Indexer withWet5Desceding() {
            this.fields = this.fields.equal(this.serialization.wet5Name, false, (Object)-1);
            return this;
        }

        public Indexer withSubs6() {
            this.fields = this.fields.equal(this.serialization.subs6Name, false, (Object)1);
            return this;
        }

        public Indexer withSubs6Desceding() {
            this.fields = this.fields.equal(this.serialization.subs6Name, false, (Object)-1);
            return this;
        }

        public Indexer withNest7() {
            this.fields = this.fields.equal(this.serialization.nest7Name, false, (Object)1);
            return this;
        }

        public Indexer withNest7Desceding() {
            this.fields = this.fields.equal(this.serialization.nest7Name, false, (Object)-1);
            return this;
        }

        public Indexer withTup3() {
            this.fields = this.fields.equal(this.serialization.tup3Name, false, (Object)1);
            return this;
        }

        public Indexer withTup3Desceding() {
            this.fields = this.fields.equal(this.serialization.tup3Name, false, (Object)-1);
            return this;
        }

        public Indexer withInt9() {
            this.fields = this.fields.equal(this.serialization.int9Name, false, (Object)1);
            return this;
        }

        public Indexer withInt9Desceding() {
            this.fields = this.fields.equal(this.serialization.int9Name, false, (Object)-1);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillyStructureWithId, Modifier> {
        private final Serialization serialization;

        private Modifier(SillyStructureWithIdRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setAttr1(String value) {
            this.setFields = this.setFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initAttr1(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setFlag2(boolean value) {
            this.setFields = this.setFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initFlag2(boolean value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier emptyOpt3() {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, null);
            return this;
        }

        public Modifier setOpt3(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initOpt3(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt3Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier emptyOpt4() {
            this.setFields = this.setFields.equal(this.serialization.opt4Name, false, null);
            return this;
        }

        public Modifier setOpt4(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt4Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initOpt4(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt4Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier emptyOpt5() {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, null);
            return this;
        }

        public Modifier setOpt5(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initOpt5(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt5Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setVery4(long value) {
            this.setFields = this.setFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initVery4(long value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementVery4(long increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.very4Name, false, (Object)increment);
            return this;
        }

        public Modifier setWet5(double value) {
            this.setFields = this.setFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initWet5(double value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementWet5(double increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.wet5Name, false, (Object)increment);
            return this;
        }

        public Modifier clearSubs6() {
            this.setFields = this.setFields.equal(this.serialization.subs6Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeSubs6(SillySubstructure value) {
            this.pullFields = this.pullFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            return this;
        }

        public Modifier addSubs6(SillySubstructure value) {
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            return this;
        }

        public Modifier addAllSubs6(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, v);
            return this;
        }

        public Modifier setNest7(SillySubstructure value) {
            this.setFields = this.setFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            return this;
        }

        public Modifier initNest7(SillySubstructure value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            return this;
        }

        public Modifier emptyTup3() {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, null);
            return this;
        }

        public Modifier setTup3(SillyTuplie value) {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            return this;
        }

        public Modifier initTup3(SillyTuplie value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            return this;
        }

        public Modifier setInt9(int value) {
            this.setFields = this.setFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initInt9(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementInt9(int increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.int9Name, false, (Object)increment);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillyStructureWithId> {
        private final Serialization serialization;

        private Updater(SillyStructureWithIdRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setAttr1(String value) {
            this.setFields = this.setFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initAttr1(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater setFlag2(boolean value) {
            this.setFields = this.setFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initFlag2(boolean value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater emptyOpt3() {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, null);
            return this;
        }

        public Updater setOpt3(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initOpt3(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt3Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater emptyOpt4() {
            this.setFields = this.setFields.equal(this.serialization.opt4Name, false, null);
            return this;
        }

        public Updater setOpt4(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt4Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initOpt4(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt4Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater emptyOpt5() {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, null);
            return this;
        }

        public Updater setOpt5(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initOpt5(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt5Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater setVery4(long value) {
            this.setFields = this.setFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initVery4(long value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementVery4(long increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.very4Name, false, (Object)increment);
            return this;
        }

        public Updater setWet5(double value) {
            this.setFields = this.setFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initWet5(double value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementWet5(double increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.wet5Name, false, (Object)increment);
            return this;
        }

        public Updater clearSubs6() {
            this.setFields = this.setFields.equal(this.serialization.subs6Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeSubs6(SillySubstructure value) {
            this.pullFields = this.pullFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            return this;
        }

        public Updater addSubs6(SillySubstructure value) {
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            return this;
        }

        public Updater addAllSubs6(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6TypeAdapter, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, v);
            return this;
        }

        public Updater setNest7(SillySubstructure value) {
            this.setFields = this.setFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            return this;
        }

        public Updater initNest7(SillySubstructure value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7TypeAdapter, (Object)value));
            return this;
        }

        public Updater emptyTup3() {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, null);
            return this;
        }

        public Updater setTup3(SillyTuplie value) {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            return this;
        }

        public Updater initTup3(SillyTuplie value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3TypeAdapter, (Object)value));
            return this;
        }

        public Updater setInt9(int value) {
            this.setFields = this.setFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initInt9(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementInt9(int increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.int9Name, false, (Object)increment);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Finder
    extends Repositories.Finder<SillyStructureWithId, Finder> {
        private final Serialization serialization;

        private Finder(SillyStructureWithIdRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Finder orderByAttr1() {
            this.ordering = this.ordering.equal(this.serialization.attr1Name, false, (Object)1);
            return this;
        }

        public Finder orderByAttr1Desceding() {
            this.ordering = this.ordering.equal(this.serialization.attr1Name, false, (Object)-1);
            return this;
        }

        public Finder orderByFlag2() {
            this.ordering = this.ordering.equal(this.serialization.flag2Name, false, (Object)1);
            return this;
        }

        public Finder orderByFlag2Desceding() {
            this.ordering = this.ordering.equal(this.serialization.flag2Name, false, (Object)-1);
            return this;
        }

        public Finder orderByOpt3() {
            this.ordering = this.ordering.equal(this.serialization.opt3Name, false, (Object)1);
            return this;
        }

        public Finder orderByOpt3Desceding() {
            this.ordering = this.ordering.equal(this.serialization.opt3Name, false, (Object)-1);
            return this;
        }

        public Finder orderByOpt4() {
            this.ordering = this.ordering.equal(this.serialization.opt4Name, false, (Object)1);
            return this;
        }

        public Finder orderByOpt4Desceding() {
            this.ordering = this.ordering.equal(this.serialization.opt4Name, false, (Object)-1);
            return this;
        }

        public Finder orderByOpt5() {
            this.ordering = this.ordering.equal(this.serialization.opt5Name, false, (Object)1);
            return this;
        }

        public Finder orderByOpt5Desceding() {
            this.ordering = this.ordering.equal(this.serialization.opt5Name, false, (Object)-1);
            return this;
        }

        public Finder orderByVery4() {
            this.ordering = this.ordering.equal(this.serialization.very4Name, false, (Object)1);
            return this;
        }

        public Finder orderByVery4Desceding() {
            this.ordering = this.ordering.equal(this.serialization.very4Name, false, (Object)-1);
            return this;
        }

        public Finder orderByWet5() {
            this.ordering = this.ordering.equal(this.serialization.wet5Name, false, (Object)1);
            return this;
        }

        public Finder orderByWet5Desceding() {
            this.ordering = this.ordering.equal(this.serialization.wet5Name, false, (Object)-1);
            return this;
        }

        public Finder orderBySubs6() {
            this.ordering = this.ordering.equal(this.serialization.subs6Name, false, (Object)1);
            return this;
        }

        public Finder orderBySubs6Desceding() {
            this.ordering = this.ordering.equal(this.serialization.subs6Name, false, (Object)-1);
            return this;
        }

        public Finder orderByNest7() {
            this.ordering = this.ordering.equal(this.serialization.nest7Name, false, (Object)1);
            return this;
        }

        public Finder orderByNest7Desceding() {
            this.ordering = this.ordering.equal(this.serialization.nest7Name, false, (Object)-1);
            return this;
        }

        public Finder orderByTup3() {
            this.ordering = this.ordering.equal(this.serialization.tup3Name, false, (Object)1);
            return this;
        }

        public Finder orderByTup3Desceding() {
            this.ordering = this.ordering.equal(this.serialization.tup3Name, false, (Object)-1);
            return this;
        }

        public Finder orderByInt9() {
            this.ordering = this.ordering.equal(this.serialization.int9Name, false, (Object)1);
            return this;
        }

        public Finder orderByInt9Desceding() {
            this.ordering = this.ordering.equal(this.serialization.int9Name, false, (Object)-1);
            return this;
        }

        public Finder excludeOpt3() {
            this.exclusion = this.exclusion.equal(this.serialization.opt3Name, false, (Object)-1);
            return this;
        }

        public Finder excludeOpt4() {
            this.exclusion = this.exclusion.equal(this.serialization.opt4Name, false, (Object)-1);
            return this;
        }

        public Finder excludeOpt5() {
            this.exclusion = this.exclusion.equal(this.serialization.opt5Name, false, (Object)-1);
            return this;
        }

        public Finder excludeSubs6() {
            this.exclusion = this.exclusion.equal(this.serialization.subs6Name, false, (Object)-1);
            return this;
        }

        public Finder excludeTup3() {
            this.exclusion = this.exclusion.equal(this.serialization.tup3Name, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((SillyStructureWithIdRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }
    }
}

