/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.annotation.Be;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableBe
implements Be {
    private static final Class<? extends Number>[] DEFAULT_VALUE_CL;
    private final Class<? extends Number>[] cl;

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private ImmutableBe(Builder builder) {
        this.cl = builder.cl != null ? builder.cl : DEFAULT_VALUE_CL;
    }

    private ImmutableBe(Class<? extends Number>[] cl) {
        this.cl = cl;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Be.class;
    }

    @Override
    public Class<? extends Number>[] cl() {
        return (Class[])this.cl.clone();
    }

    @SafeVarargs
    public final ImmutableBe withCl(Class<? extends Number> ... elements) {
        Class[] newValue = (Class[])elements.clone();
        return new ImmutableBe(newValue);
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Be && this.equalTo((Be)another);
    }

    private boolean equalTo(Be another) {
        return Arrays.equals(this.cl, another.cl());
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "cl".hashCode() ^ Arrays.hashCode(this.cl);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"@Be").add("cl", (Object)Arrays.toString(this.cl)).toString();
    }

    public static ImmutableBe copyOf(Be instance) {
        if (instance instanceof ImmutableBe) {
            return (ImmutableBe)instance;
        }
        return ImmutableBe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        try {
            DEFAULT_VALUE_CL = (Class[])ImmutableBe.cast(Be.class.getDeclaredMethod("cl", new Class[0]).getDefaultValue());
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @NotThreadSafe
    static final class Builder {
        @Nullable
        private Class<? extends Number>[] cl;

        private Builder() {
        }

        public final Builder from(Be instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.cl(instance.cl());
            return this;
        }

        @SafeVarargs
        public final Builder cl(Class<? extends Number> ... elements) {
            this.cl = (Class[])elements.clone();
            return this;
        }

        public ImmutableBe build() throws IllegalStateException {
            return new ImmutableBe(this);
        }
    }
}

