/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.annotation.NoDefault;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableNoDefault
implements NoDefault {
    private final int value;
    private final String otherValue;

    private ImmutableNoDefault(int value, String otherValue) {
        this.value = value;
        this.otherValue = otherValue;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NoDefault.class;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public String otherValue() {
        return this.otherValue;
    }

    public final ImmutableNoDefault withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableNoDefault(value, this.otherValue);
    }

    public final ImmutableNoDefault withOtherValue(String value) {
        if (this.otherValue.equals(value)) {
            return this;
        }
        return new ImmutableNoDefault(this.value, (String)Preconditions.checkNotNull((Object)value, (Object)"otherValue"));
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NoDefault && this.equalTo((NoDefault)another);
    }

    private boolean equalTo(NoDefault another) {
        return this.value == another.value() && this.otherValue.equals(another.otherValue());
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "value".hashCode() ^ this.value;
        return h += 127 * "otherValue".hashCode() ^ this.otherValue.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"@NoDefault").add("value", this.value).add("otherValue", (Object)this.otherValue).toString();
    }

    public static ImmutableNoDefault copyOf(NoDefault instance) {
        if (instance instanceof ImmutableNoDefault) {
            return (ImmutableNoDefault)instance;
        }
        return ImmutableNoDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_OTHER_VALUE = 2L;
        private long initBits = 3L;
        private int value;
        @Nullable
        private String otherValue;

        private Builder() {
        }

        public final Builder from(NoDefault instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.value(instance.value());
            this.otherValue(instance.otherValue());
            return this;
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder otherValue(String otherValue) {
            this.otherValue = (String)Preconditions.checkNotNull((Object)otherValue, (Object)"otherValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNoDefault build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNoDefault(this.value, this.otherValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("otherValue");
            }
            return "Cannot build NoDefault, some of required attributes are not set " + attributes;
        }
    }
}

