/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ast.InstantiationGenerics;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableStringLeaf
implements InstantiationGenerics.StringLeaf {
    private final String value;

    private ImmutableStringLeaf(String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    private ImmutableStringLeaf(ImmutableStringLeaf original, String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return this.value;
    }

    public final ImmutableStringLeaf withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        return new ImmutableStringLeaf(this, (String)Preconditions.checkNotNull((Object)value, (Object)"value"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStringLeaf && this.equalTo((ImmutableStringLeaf)another);
    }

    private boolean equalTo(ImmutableStringLeaf another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StringLeaf").add("value", (Object)this.value).toString();
    }

    public static ImmutableStringLeaf of(String value) {
        return new ImmutableStringLeaf(value);
    }

    public static ImmutableStringLeaf copyOf(InstantiationGenerics.StringLeaf instance) {
        if (instance instanceof ImmutableStringLeaf) {
            return (ImmutableStringLeaf)instance;
        }
        return ImmutableStringLeaf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(InstantiationGenerics.StringLeaf instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.value((String)instance.value());
            return this;
        }

        public final Builder value(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStringLeaf build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStringLeaf(null, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build StringLeaf, some of required attributes are not set " + attributes;
        }
    }
}

