/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ast.InstantiationGenerics;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableStringNode
implements InstantiationGenerics.StringNode {
    private final ImmutableList<InstantiationGenerics.TreeElement<String>> elements;

    private ImmutableStringNode(ImmutableList<InstantiationGenerics.TreeElement<String>> elements) {
        this.elements = elements;
    }

    @Override
    public ImmutableList<InstantiationGenerics.TreeElement<String>> elements() {
        return this.elements;
    }

    @SafeVarargs
    public final ImmutableStringNode withElements(InstantiationGenerics.TreeElement<String> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStringNode((ImmutableList<InstantiationGenerics.TreeElement<String>>)newValue);
    }

    public final ImmutableStringNode withElements(Iterable<? extends InstantiationGenerics.TreeElement<String>> elements) {
        if (this.elements == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStringNode((ImmutableList<InstantiationGenerics.TreeElement<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStringNode && this.equalTo((ImmutableStringNode)another);
    }

    private boolean equalTo(ImmutableStringNode another) {
        return this.elements.equals(another.elements);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.elements.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StringNode").add("elements", this.elements).toString();
    }

    public static ImmutableStringNode copyOf(InstantiationGenerics.StringNode instance) {
        if (instance instanceof ImmutableStringNode) {
            return (ImmutableStringNode)instance;
        }
        return ImmutableStringNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<InstantiationGenerics.TreeElement<String>> elementsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(InstantiationGenerics.StringNode instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllElements(instance.elements());
            return this;
        }

        public final Builder addElements(InstantiationGenerics.TreeElement<String> element) {
            this.elementsBuilder.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder addElements(InstantiationGenerics.TreeElement<String> ... elements) {
            this.elementsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder elements(Iterable<? extends InstantiationGenerics.TreeElement<String>> elements) {
            this.elementsBuilder = ImmutableList.builder();
            return this.addAllElements(elements);
        }

        public final Builder addAllElements(Iterable<? extends InstantiationGenerics.TreeElement<String>> elements) {
            this.elementsBuilder.addAll(elements);
            return this;
        }

        public ImmutableStringNode build() throws IllegalStateException {
            return new ImmutableStringNode(this.elementsBuilder.build());
        }
    }
}

