/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.couse;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.couse.AbstractA;
import org.immutables.fixture.couse.B;
import org.immutables.fixture.couse.sub.C;

@ParametersAreNonnullByDefault
@Immutable
public final class A
implements AbstractA {
    private final B b;
    private final C c;

    private A(B b, C c) {
        this.b = b;
        this.c = c;
    }

    @Override
    public B b() {
        return this.b;
    }

    @Override
    public C c() {
        return this.c;
    }

    public final A withB(B value) {
        if (this.b == value) {
            return this;
        }
        return new A((B)Preconditions.checkNotNull((Object)value, (Object)"b"), this.c);
    }

    public final A withC(C value) {
        if (this.c == value) {
            return this;
        }
        return new A(this.b, (C)Preconditions.checkNotNull((Object)value, (Object)"c"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof A && this.equalTo((A)another);
    }

    private boolean equalTo(A another) {
        return this.b.equals(another.b) && this.c.equals(another.c);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.b.hashCode();
        h = h * 17 + this.c.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"A").add("b", (Object)this.b).add("c", (Object)this.c).toString();
    }

    static A copyOf(AbstractA instance) {
        if (instance instanceof A) {
            return (A)instance;
        }
        return A.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_B = 1L;
        private static final long INIT_BIT_C = 2L;
        private long initBits = 3L;
        @Nullable
        private B b;
        @Nullable
        private C c;

        private Builder() {
        }

        public final Builder from(A instance) {
            return this.from((AbstractA)instance);
        }

        final Builder from(AbstractA instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.b(instance.b());
            this.c(instance.c());
            return this;
        }

        public final Builder b(B b) {
            this.b = (B)Preconditions.checkNotNull((Object)b, (Object)"b");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder c(C c) {
            this.c = (C)Preconditions.checkNotNull((Object)c, (Object)"c");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public A build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new A(this.b, this.c);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("c");
            }
            return "Cannot build A, some of required attributes are not set " + attributes;
        }
    }
}

