/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import org.immutables.fixture.deep.ImmutableColor;
import org.immutables.fixture.deep.ImmutableLine;
import org.immutables.fixture.deep.ImmutablePoint;
import org.immutables.value.Value;

@Value.Style(deepImmutablesDetection=true)
public interface Canvas {
    default public void use() {
        ImmutableLine line = ImmutableLine.builder().startOf(1, 2).endOf(2, 3).colorOf(0.9, 0.7, 0.4).build();
        ImmutablePoint start = line.start();
        ImmutablePoint end = line.end();
        ImmutableColor color = line.color();
        ImmutableLine.builder().start(start).end(end).color(color).build();
    }

    @Value.Immutable
    public static interface Point {
        @Value.Parameter
        public int x();

        @Value.Parameter
        public int y();
    }

    @Value.Immutable
    public static interface Line {
        public Point start();

        public Point end();

        public Color color();
    }

    @Value.Immutable
    public static interface Color {
        @Value.Parameter
        public double red();

        @Value.Parameter
        public double green();

        @Value.Parameter
        public double blue();
    }
}

