/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableColor
implements Canvas.Color {
    private final double red;
    private final double green;
    private final double blue;

    private ImmutableColor(double red, double green, double blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @Override
    public double red() {
        return this.red;
    }

    @Override
    public double green() {
        return this.green;
    }

    @Override
    public double blue() {
        return this.blue;
    }

    public final ImmutableColor withRed(double value) {
        if (Double.doubleToLongBits(this.red) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableColor(value, this.green, this.blue);
    }

    public final ImmutableColor withGreen(double value) {
        if (Double.doubleToLongBits(this.green) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableColor(this.red, value, this.blue);
    }

    public final ImmutableColor withBlue(double value) {
        if (Double.doubleToLongBits(this.blue) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableColor(this.red, this.green, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColor && this.equalTo((ImmutableColor)another);
    }

    private boolean equalTo(ImmutableColor another) {
        return Double.doubleToLongBits(this.red) == Double.doubleToLongBits(another.red) && Double.doubleToLongBits(this.green) == Double.doubleToLongBits(another.green) && Double.doubleToLongBits(this.blue) == Double.doubleToLongBits(another.blue);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Doubles.hashCode((double)this.red);
        h = h * 17 + Doubles.hashCode((double)this.green);
        h = h * 17 + Doubles.hashCode((double)this.blue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Color").add("red", this.red).add("green", this.green).add("blue", this.blue).toString();
    }

    public static ImmutableColor of(double red, double green, double blue) {
        return new ImmutableColor(red, green, blue);
    }

    public static ImmutableColor copyOf(Canvas.Color instance) {
        if (instance instanceof ImmutableColor) {
            return (ImmutableColor)instance;
        }
        return ImmutableColor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RED = 1L;
        private static final long INIT_BIT_GREEN = 2L;
        private static final long INIT_BIT_BLUE = 4L;
        private long initBits = 7L;
        private double red;
        private double green;
        private double blue;

        private Builder() {
        }

        public final Builder from(Canvas.Color instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.red(instance.red());
            this.green(instance.green());
            this.blue(instance.blue());
            return this;
        }

        public final Builder red(double red) {
            this.red = red;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder green(double green) {
            this.green = green;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder blue(double blue) {
            this.blue = blue;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableColor build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColor(this.red, this.green, this.blue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("red");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("green");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("blue");
            }
            return "Cannot build Color, some of required attributes are not set " + attributes;
        }
    }
}

